<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?= $title ?></title>

    <link rel="stylesheet" href="<?php echo admin_css() ?>plugins/sweetalert/sweetalert.min.css">
    <script src="<?php echo admin_css() ?>plugins/sweetalert/sweetalert.min.js"></script>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=falladmin_css">
    <link rel="stylesheet" href="<?php echo admin_css(); ?>plugins/fontawesome-free/css/all.min.css">
    <link rel="stylesheet" href="<?php echo admin_css(); ?>plugins/icheck-bootstrap/icheck-bootstrap.min.css">
    <link rel="stylesheet" href="<?php echo admin_css(); ?>dist/css/adminlte.min.css">
    <link rel="stylesheet" href="<?php echo admin_css(); ?>dist/css/custom.css">
</head>

<body class="hold-transition login-page">
    <div class="login-box">
        <div class="login-logo">
            <a href="<?php echo base_url(); ?>"><b><?php echo $app_setting->app_name ?></b></a>
        </div>
        <div class="card">
            <div class="card-body login-card-body">
                <p class="login-box-msg">Sign in to start your session</p>
                <p class="text-danger text-center">
                    <?php
                    $errors =  session()->get('error');
                    if (isset($errors)) { ?>
                        <script>
                            swal("Oops", "<?php echo $errors ?>", "error")
                        </script>
                    <?php }
                    session()->remove('error');
                    $success =  session()->get('success');
                    if (isset($success)) { ?>
                        <script>
                            swal("Done", "<?php echo $success ?>", "success")
                        </script>
                    <?php }
                    session()->remove('success');
                    ?>
                </p>
                <?php echo form_open(base_url() . '/login', ['id' => 'mobile_login']); ?>
                <?php if ($validation->getError('mobile')) { ?>
                    <div class='text-danger'>
                        <?= $validation->getError('mobile'); ?>
                    </div>
                <?php } ?>
                <div class="input-group mb-3">
                    <input type="number" class="form-control" placeholder="Mobile No" name="user_mobile" required>
                    <div class="input-group-append">
                        <div class="input-group-text">
                            <span class="fas fa-phone"></span>
                        </div>
                    </div>
                </div>
                <?php if ($validation->getError('password')) { ?>
                    <div class='text-danger'>
                        <?= $validation->getError('password'); ?>
                    </div>
                <?php } ?>
                <div class="input-group mb-3">
                    <input type="password" class="form-control" placeholder="Password" name="user_password" id="passwordField" required>
                    <div class="input-group-append">
                        <div class="input-group-text">
                            <span id="togglePassword" class="fas fa-eye-slash" onclick="togglePasswordVisibility()"></span>
                        </div>
                    </div>
                </div>


                <div class="row">
                    <div class="col-4">
                        <button type="submit" name="submit" class="btn btn-primary btn-block">Sign In</button>
                    </div>
                    <div class="col-8 text-center" style="right: 0;">
                        <a href="<?php echo base_url() ?>/forgot_password">Forgot Password</a>
                    </div>
                </div>
                <?php echo form_close(); ?>

            </div>
        </div>

        <script type="text/javascript">
            function togglePasswordVisibility() {
                var passwordField = document.getElementById("passwordField");
                var toggleIcon = document.getElementById("togglePassword");

                if (passwordField.type === "password") {
                    passwordField.type = "text";
                    toggleIcon.classList.remove("fas", "fa-eye-slash");
                    toggleIcon.classList.add("fas", "fa-eye");
                } else {
                    passwordField.type = "password";
                    toggleIcon.classList.remove("fas", "fa-eye");
                    toggleIcon.classList.add("fas", "fa-eye-slash");
                }
            }
        </script>
        <script src="<?php echo admin_css(); ?>plugins/jquery/jquery.min.js"></script>
        <script src="<?php echo admin_css(); ?>plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
        <script src="<?php echo admin_css(); ?>dist/js/adminlte.min.js"></script>
        <script src="https://www.gstatic.com/firebasejs/8.3.0/firebase-app.js" defer></script>
        <script src="https://www.gstatic.com/firebasejs/8.3.0/firebase-analytics.js" defer></script>
        <script defer src="https://www.gstatic.com/firebasejs/7.19.0/firebase-auth.js" defer></script>
        <script src="<?php echo admin_css(); ?>dist/js/custom.js"></script>
</body>

</html>
<style type="text/css">
    /* Style for the eye icon */
    #togglePassword {
        cursor: pointer;
    }

    /* Hide the password by default */
    #passwordField[type="password"] {
        -webkit-text-security: disc;
        text-security: disc;
    }
</style>