<?php

use App\Models\TourModel;

$uri = service('uri');

$actual_link = (empty($_SERVER['HTTPS']) ? 'http' : 'https') . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
if (isset($og_image)) {
    $fev_image = $og_image;
} else {
    $fev_image = $app_setting->app_fevicon;
}
$category = new TourModel();
?>

<!DOCTYPE html>

<html>

<head>
    <meta charset="utf-8">
    <title><?php echo $title; ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
    <meta name="description" content="<?php echo $description; ?>">
    <meta name="keywords" content="<?php echo $keyword; ?>">
    <meta name="author" content="<?php echo $app_setting->app_name; ?>">

    <meta property="og:title" content="<?php echo $title; ?>" />
    <meta property="og:type" content="website" />
    <meta property="og:URL" content="<?php echo $actual_link; ?>" />
    <meta property="og:site_name" content="<?php echo $app_setting->app_name; ?>" />
    <meta property="og:image" content="<?php echo base_url(); ?><?php echo $fev_image; ?>" />
    <meta property="og:description" content="<?php echo $description; ?>" />
    <link rel="icon" type="image/png" href="<?php echo base_url(); ?><?php echo $app_setting->app_fevicon; ?>">

    <!-- Theme Style -->
    <link rel="stylesheet" type="text/css" href="<?php echo front_css(); ?>css/bootstrap.css">
    <link rel="stylesheet" type="text/css" href="<?php echo front_css(); ?>css/animate.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo front_css(); ?>css/odometer.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo front_css(); ?>css/swiper-bundle.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo front_css(); ?>css/styles.css">

    <!-- Font -->
    <link rel="stylesheet" href="<?php echo front_css(); ?>font/fonts.css">

    <!-- Icon -->
    <link rel="stylesheet" type="text/css" href="<?php echo front_css(); ?>icons/icomoon/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/css/iziToast.css" integrity="sha512-DIW4FkYTOxjCqRt7oS9BFO+nVOwDL4bzukDyDtMO7crjUZhwpyrWBFroq+IqRe6VnJkTpRAS6nhDvf0w+wHmxg==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/js/iziToast.min.js" integrity="sha512-Zq9o+E00xhhR/7vJ49mxFNJ0KQw1E1TMWkPTxrWcnpfEFDEXgUiwJHIKit93EW/XxE31HSI5GEOW06G6BF1AtA==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
</head>

<body>
    <!-- wrapper -->
    <div id="wrapper">

        <!-- preload -->
        <div id="loading">
            <div id="loading-center">
                <div class="loader-container">
                    <div class="wrap-loader">
                        <div class="loader">
                        </div>
                        <div class="icon">
                            <img src="<?php echo base_url(); ?><?php echo $fev_image; ?>" alt="<?php echo $app_setting->app_name; ?>">
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- /preload -->

        <!-- top-bar -->
        <div class="tf-top-bar d-none d-lg-block">
            <div class="wrap-top-bar">
                <div class="top-bar-left">
                    <ul class="top-info">
                        <li class="text-2"> <i class="icon-PhoneCall"></i><?php echo $app_setting->app_mobile; ?></li>
                        <li class="text-2">
                            <i class="icon-Envelope
                            "></i><a href="mailto:<?php echo $app_setting->app_email; ?>"><?php echo $app_setting->app_email; ?></a>
                        </li>
                    </ul>
                </div>
                <div class="top-bar-right">
                    <ul class="list">
                        <li>
                            <ul class="tf-social style-1">
                                <?php if ($app_setting->app_facebook): ?>
                                    <li>
                                        <a href="<?php echo $app_setting->app_facebook; ?>" target="_blank">
                                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="#3C210E" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                                <path d="M18 2h-3a5 5 0 0 0-5 5v3H7v4h3v8h4v-8h3l1-4h-4V7a1 1 0 0 1 1-1h3z" />
                                            </svg>
                                        </a>
                                    </li>
                                <?php endif;
                                if ($app_setting->app_youtube): ?>
                                    <li>
                                        <a href="<?php echo $app_setting->app_youtube; ?>" target="_blank">
                                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="#3C210E" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                                <path d="M22.54 6.42a2.79 2.79 0 0 0-1.97-2C18.88 4 12 4 12 4s-6.88 0-8.57.42a2.79 2.79 0 0 0-1.97 2A29.94 29.94 0 0 0 1 12a29.94 29.94 0 0 0 .46 5.58 2.79 2.79 0 0 0 1.97 2C5.12 20 12 20 12 20s6.88 0 8.57-.42a2.79 2.79 0 0 0 1.97-2A29.94 29.94 0 0 0 23 12a29.94 29.94 0 0 0-.46-5.58z" />
                                                <polygon points="9.75 15.02 15.5 12 9.75 8.98 9.75 15.02" />
                                            </svg>
                                        </a>
                                    </li>
                                <?php endif;
                                if ($app_setting->app_instagram): ?>
                                    <li>
                                        <a href="<?php echo $app_setting->app_instagram; ?>" target="_blank">
                                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="#3C210E" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                                <rect x="2" y="2" width="20" height="20" rx="5" ry="5" />
                                                <path d="M16 11.37A4 4 0 1 1 12.63 8 4 4 0 0 1 16 11.37z" />
                                                <line x1="17.5" y1="6.5" x2="17.5" y2="6.5" />
                                            </svg>
                                        </a>
                                    </li>
                                <?php endif; ?>
                            </ul>
                        </li>
                    </ul>
                </div>
            </div>
            <div class="btn-show-top">
                <span class="arrows"></span>
                <!-- <i class="icon-CaretDown"></i> -->
            </div>
        </div>

        <div class="tf-top-bar d-lg-none">
            <div class="wrap-top-bar">
                <div class="top-bar-left">
                    <ul class="top-info">
                        <li class="text-2"><i class="icon-PhoneCall"></i><?php echo $app_setting->app_mobile; ?></li>
                        <li class="text-2">
                            <i class="icon-Envelope
                            "></i><a href="mailto:<?php echo $app_setting->app_email; ?>"><?php echo $app_setting->app_email; ?></a>
                        </li>
                    </ul>
                </div>

            </div>

        </div>
        <!-- /top-bar -->

        <!-- header -->
        <header id="header-main" class="header style-1">
            <div class="header-inner">
                <div class="header-inner-wrap w-1790">
                    <div class="mobile-button" data-bs-toggle="offcanvas" data-bs-target="#menu-mobile" aria-controls="menu-mobile">
                        <i class="icon-menu"></i>
                    </div>
                    <div class="header-left">
                        <div class="header-logo">
                            <a href="<?php echo base_url(); ?>" class="site-logo">
                                <img id="logo_header" alt="<?php echo $app_setting->app_name; ?>" src="<?php echo base_url(); ?><?php echo $app_setting->app_logo; ?>" data-retina="<?php echo base_url(); ?><?php echo $app_setting->app_logo; ?>">
                            </a>
                        </div>
                        <nav class="main-menu">
                            <ul class="navigation">
                                <li>
                                    <a href="<?php echo base_url(); ?>">Home</a>
                                </li>
                                <li>
                                    <a href="<?php echo base_url(); ?>about_us">About</a>
                                </li>
                                <li class="has-child ">
                                    <a href="#">Services</a>
                                    <div class="sub-menu service-link">
                                        <div class="tf-container">
                                            <div class="row">
                                                <div class="col-12">
                                                    <div class="wrap-cta">
                                                        <h5 class="wg-title">Counseling & Therapy Services
                                                        </h5>
                                                        <div class="wrap-service">
                                                            <?php $all_category = $category->get_all_package_for_home();
                                                            foreach ($all_category as $key => $category):
                                                            ?>
                                                                <div class="service-item-list">
                                                                    <h6><a href="<?php echo base_url(); ?><?php echo $category->package_slug; ?>"><?php echo $category->package_title; ?></a></h6>
                                                                    <p class="text-2">
                                                                        <?php echo mb_strimwidth($category->package_front_description, 0, 70, "...") ?>
                                                                    </p>
                                                                </div>
                                                            <?php endforeach; ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </li>
                                <li class="has-child relative current-menu-item">
                                    <a href="javascript:void(0)">Gallery</a>
                                    <ul class="sub-menu">
                                        <li class="current-item">
                                            <a href="<?php echo base_url(); ?>gallery/video">Video</a>
                                        </li>
                                        <li>
                                            <a href="<?php echo base_url(); ?>gallery/photo">Photo</a>
                                        </li>

                                    </ul>
                                </li>
                                <li>
                                    <a href="<?php echo base_url(); ?>blogs">Blogs</a>

                                </li>
                                <li>
                                    <a href="<?php echo base_url(); ?>contact_us">Contact</a>
                                </li>
                            </ul>
                        </nav>
                    </div>
                    <!-- <div class="header-right">

                        <div class="btn-get">
                            <a class="tf-btn style-default btn-color-secondary pd-40" href="book-appointment.html">
                                <span>
                                    Get Your Consult!
                                </span>
                            </a>
                        </div>
                    </div> -->
                </div>

            </div>
        </header>
        <!-- /header -->
        <?php
        $errors =  session()->get('error');
        if (isset($errors)) { ?>
            <script>
                iziToast.error({
                    title: 'Error',
                    message: '<?php echo $errors ?>',
                });
            </script>
        <?php }
        session()->remove('error');
        $success =  session()->get('success');
        if (isset($success)) { ?>
            <script>
                iziToast.success({
                    title: 'OK',
                    message: '<?php echo $success ?>',
                    position: 'topRight',
                    messageColor: '#000'
                });
            </script>
        <?php }
        session()->remove('success');
        ?>