<?php

use App\Models\FrontModel;
use App\Models\TourModel;

$category = new TourModel();
$front = new FrontModel();
$all_pages = $front->get_all_page();

?>
<footer id="footer">
    <div class="tf-container">
        <div class="row">
            <div class="col-12">
                <div class="footer-main">
                    <div class="footer-left">
                        <div class="footer-logo">
                            <a href="index.html">
                                <img id="logo_footer" src="<?php echo base_url(); ?><?php echo $app_setting->app_footer_logo; ?>" data-retina="<?php echo base_url(); ?><?php echo $app_setting->app_footer_logo; ?>" alt="">
                            </a>
                        </div>
                        <p class="description"><?php echo $app_setting->app_footer_about_us; ?>
                        </p>
                        <ul class="footer-info">
                            <li><?php echo $app_setting->app_address ?></li>
                            <li>Support 24/7: <a href="mailto:<?php echo $app_setting->app_email; ?>"><?php echo $app_setting->app_email; ?></a></li>
                            <li>Call Us Now: <?php echo $app_setting->app_mobile; ?></li>
                        </ul>
                        <ul class="tf-social">

                            <?php if ($app_setting->app_facebook): ?>
                                <li>
                                    <a href="<?php echo $app_setting->app_facebook; ?>" target="_blank">
                                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                            <path d="M18 2h-3a5 5 0 0 0-5 5v3H7v4h3v8h4v-8h3l1-4h-4V7a1 1 0 0 1 1-1h3z" />
                                        </svg>
                                    </a>
                                </li>
                            <?php endif;
                            if ($app_setting->app_youtube): ?>
                                <li>
                                    <a href="<?php echo $app_setting->app_youtube; ?>" target="_blank">
                                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                            <path d="M22.54 6.42a2.79 2.79 0 0 0-1.97-2C18.88 4 12 4 12 4s-6.88 0-8.57.42a2.79 2.79 0 0 0-1.97 2A29.94 29.94 0 0 0 1 12a29.94 29.94 0 0 0 .46 5.58 2.79 2.79 0 0 0 1.97 2C5.12 20 12 20 12 20s6.88 0 8.57-.42a2.79 2.79 0 0 0 1.97-2A29.94 29.94 0 0 0 23 12a29.94 29.94 0 0 0-.46-5.58z" />
                                            <polygon points="9.75 15.02 15.5 12 9.75 8.98 9.75 15.02" />
                                        </svg>
                                    </a>
                                </li>
                            <?php endif;
                            if ($app_setting->app_instagram): ?>
                                <li>
                                    <a href="<?php echo $app_setting->app_instagram; ?>" target="_blank">
                                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="#fff" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                            <rect x="2" y="2" width="20" height="20" rx="5" ry="5" />
                                            <path d="M16 11.37A4 4 0 1 1 12.63 8 4 4 0 0 1 16 11.37z" />
                                            <line x1="17.5" y1="6.5" x2="17.5" y2="6.5" />
                                        </svg>
                                    </a>
                                </li>
                            <?php endif; ?>

                        </ul>
                    </div>
                    <div class="footer-right">
                        <div class="wrap-footer-menu-list">
                            <div class="footer-menu-list footer-col-block">
                                <h6 class="title title-desktop">Quick Links</h6>
                                <h6 class="title title-mobile">Quick Links</h6>
                                <ul class="tf-collapse-content">
                                    <li>
                                        <a href="<?php echo base_url(); ?>">Home</a>
                                    </li>
                                    <li>
                                        <a href="<?php echo base_url(); ?>about_us">About us</a>
                                    </li>
                                    <li>
                                        <a href="<?php echo base_url(); ?>blogs">Blogs</a>
                                    </li>

                                </ul>
                            </div>
                            <div class="footer-menu-list footer-col-block">
                                <h6 class="title title-desktop">Useful Links</h6>
                                <h6 class="title title-mobile">Useful Links</h6>
                                <ul class="tf-collapse-content">

                                    <?php foreach ($all_pages as $key => $pages): ?>
                                        <li>
                                            <a href="<?php echo base_url(); ?><?php echo $pages->page_slug; ?>"><?php echo $pages->page_name; ?></a>
                                        </li>
                                    <?php endforeach; ?>

                                    <li>
                                        <a href="<?php echo base_url(); ?>contact_us">Contact us</a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                        <div class="wrap-form footer-col-block">
                            <h6 class="title title-desktop">Subscribe Newsletter</h6>
                            <h6 class="title title-mobile">Subscribe Newsletter</h6>
                            <div class="tf-collapse-content">
                                <form class="form-send-email">
                                    <fieldset>
                                        <input type="email" placeholder="Your email address" name="text" aria-required="true" required="">
                                    </fieldset>
                                    <div class="button-submit">
                                        <button type="submit">
                                            <i class="icon-PaperPlaneTilt"></i>
                                        </button>
                                    </div>
                                </form>
                                <p>Please sign up to follow the latest news and events from us, we promise not
                                    to
                                    spam your inbox.</p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="footer-bottom">
                    <p>Copyright © <?php echo date('Y') ?> <?php echo $app_setting->app_name; ?> All rights reserved</p>

                </div>
            </div>
        </div>
    </div>
</footer>
<!-- /Footer -->
</div>
<!-- /wrapper -->

<!-- mobile-nav -->
<div class="offcanvas offcanvas-start mobile-nav-wrap " tabindex="-1" id="menu-mobile" aria-labelledby="menu-mobile">
    <div class="offcanvas-header top-nav-mobile">
        <div class="offcanvas-title">
            <a href="<?php echo base_url(); ?>"><img src="<?php echo base_url(); ?><?php echo $app_setting->app_logo; ?>" alt=""></a>
        </div>
        <div data-bs-dismiss="offcanvas" aria-label="Close">
            <i class="icon-close"></i>
        </div>
    </div>
    <div class="offcanvas-body inner-mobile-nav">
        <div class="mb-body">
            <ul id="menu-mobile-menu">

                <li class="menu-item ">
                    <a href="<?php echo base_url(); ?>" class="item-menu-mobile "> Home</a>
                </li>
                <li class="menu-item ">
                    <a href="<?php echo base_url(); ?>about_us" class="item-menu-mobile "> About</a>
                </li>
                <li class="menu-item menu-item-has-children-mobile">
                    <a href="#dropdown-menu-two" class="item-menu-mobile collapsed" data-bs-toggle="collapse" aria-expanded="true" aria-controls="dropdown-menu-two">
                        Services
                    </a>
                    <div id="dropdown-menu-two" class="collapse" data-bs-parent="#menu-mobile-menu">
                        <ul class="sub-mobile">
                            <?php $all_category = $category->get_all_destination();
                            foreach ($all_category as $key => $category):
                            ?>
                                <li class="menu-item">
                                    <a href="<?php echo base_url(); ?><?php echo $category->destination_slug; ?>"><?php echo $category->destination_name; ?></a>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                </li>
                <li class="menu-item menu-item-has-children-mobile">
                    <a href="#dropdown-menu-two" class="item-menu-mobile collapsed" data-bs-toggle="collapse" aria-expanded="true" aria-controls="dropdown-menu-two">
                        Gallery
                    </a>
                    <div id="dropdown-menu-two" class="collapse" data-bs-parent="#menu-mobile-menu">
                        <ul class="sub-mobile">
                            <li class="menu-item">
                                <a href="<?php echo base_url(); ?>gallery/video">Video</a>
                            </li>
                            <li class="menu-item">
                                <a href="<?php echo base_url(); ?>gallery/image">Image</a>
                            </li>
                        </ul>
                    </div>
                </li>
                <li class="menu-item ">
                    <a href="<?php echo base_url(); ?>blogs" class="tem-menu-mobile "> Blog</a>
                </li>
                <li class="menu-item ">
                    <a href="<?php echo base_url(); ?>contact_us" class="tem-menu-mobile "> Contact</a>
                </li>
            </ul>
            <!-- <div class="support">
                <a href="#" class="text-need"> Need help?</a>
                <ul class="mb-info">
                    <li>Call Us Now: <span class="number">1-555-678-8888</span></li>
                    <li>Support 24/7: <a href="#">themesflat@gmail.com</a></li>
                </ul>
            </div> -->
        </div>
    </div>
</div>
<!-- /mobile-nav -->

<!-- prograss -->
<div class="progress-wrap">
    <svg class="progress-circle svg-content" width="100%" height="100%" viewbox="-1 -1 102 102">
        <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" style="transition: stroke-dashoffset 10ms linear; stroke-dasharray: 307.919, 307.919; stroke-dashoffset: 307.919;">
        </path>
    </svg>
</div>
<!-- /prograss -->

<!-- Javascript -->
<script type="text/javascript" src="<?php echo front_css(); ?>js/bootstrap.min.js"></script>
<script type="text/javascript" src="<?php echo front_css(); ?>js/jquery.min.js"></script>
<script type="text/javascript" src="<?php echo front_css(); ?>js/lazysize.min.js"></script>
<script type="text/javascript" src="<?php echo front_css(); ?>js/wow.min.js"></script>
<script type="text/javascript" src="<?php echo front_css(); ?>js/swiper-bundle.min.js"></script>
<script type="text/javascript" src="<?php echo front_css(); ?>js/odometer.min.js"></script>
<script type="text/javascript" src="<?php echo front_css(); ?>js/counter.js"></script>
<script type="text/javascript" src="<?php echo front_css(); ?>js/swiper.js"></script>
<script type="text/javascript" src="<?php echo front_css(); ?>js/plugin.min.js"></script>
<script type="text/javascript" src="<?php echo front_css(); ?>js/switcher.js"></script>
<script type="text/javascript" src="<?php echo front_css(); ?>js/jquery-validate.js"></script>

<script type="text/javascript" src="<?php echo front_css(); ?>js/main.js"></script>
<!-- /Javascript -->
<style>
    .switcher-container {
        display: none !important;
    }
</style>
</body>

</html>