<div class="page-title">
    <div class="tf-container">
        <div class="row">
            <div class="col-12">
                <h3 class="title"><?php echo $page_title; ?></h3>
                <ul class="breadcrumbs">
                    <li><a href="<?php echo base_url(); ?>">Home</a></li>
                    <li>Gallery</li>
                    <li><?php echo $page_title; ?></li>
                </ul>
            </div>
        </div>
    </div>
</div>

<div class="main-content-2">
    <?php if ($page_title == 'Photo'): ?>
        <section class="section-service-details">
            <div class="tf-container">
                <div class="row">
                    <?php foreach ($data as $key => $image): ?>
                        <div class="col-lg-4 mb-4">
                            <div class="content-inner">
                                <div class="image-wrap">
                                    <a href="<?php echo base_url($image->gallery_content); ?>" data-lightbox="gallery" data-title="<?php echo $image->gallery_name; ?>">
                                        <img width="100%" class="lazyload" data-src="<?php echo base_url($image->gallery_content); ?>" src="<?php echo base_url($image->gallery_content); ?>" alt="<?php echo $image->gallery_name; ?>">
                                    </a>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>

    <?php elseif ($page_title == 'Video'): ?>
        <section class="section-service-details">
            <div class="tf-container">
                <div class="row">
                    <?php foreach ($data as $key => $video): ?>
                        <div class="col-lg-6 mb-4">
                            <div class="content-inner">
                                <?php
                                    // Extract video ID from YouTube URL
                                    preg_match('/(?:youtu\.be\/|youtube\.com\/(?:watch\?v=|embed\/))([^\&\?\/]+)/', $video->gallery_content, $matches);
                                    if (!empty($matches[1])) {
                                        $video_id = $matches[1];
                                        $video_url = "https://www.youtube.com/watch?v={$video_id}";
                                        $thumbnail = "https://img.youtube.com/vi/{$video_id}/hqdefault.jpg";
                                    }
                                ?>
                                <a href="<?php echo $video_url; ?>" class="glightbox" data-glightbox="title: <?php echo $video->gallery_name; ?>;">
                                    <img src="<?php echo $thumbnail; ?>" class="img-fluid" alt="<?php echo $video->gallery_name; ?>" />
                                </a>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
    <?php endif; ?>
</div>

<!-- ✅ jQuery (for Lightbox2) -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<!-- ✅ Lightbox2 (for photo gallery) -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/lightbox2/2.11.4/css/lightbox.min.css" rel="stylesheet" />
<script src="https://cdnjs.cloudflare.com/ajax/libs/lightbox2/2.11.4/js/lightbox.min.js"></script>

<!-- ✅ GLightbox (for video lightbox support) -->
<link href="https://cdn.jsdelivr.net/npm/glightbox/dist/css/glightbox.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/glightbox/dist/js/glightbox.min.js"></script>

<!-- ✅ Initialize GLightbox -->
<script>
    const lightbox = GLightbox({
        selector: '.glightbox'
    });
</script>
