<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0 text-dark">Latest Lead</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo base_url() ?>admin/admin/dashboard">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="#">Lead</a></li>
                        <li class="breadcrumb-item active">Latest Lead</li>

                    </ol>
                </div>
            </div>
        </div>
    </div>


    <section class="content">
        <div class="container-fluid">
            <div class="card card-default">
                <div class="card-header">
                    <h3 class="card-title">View All Lead</h3>
                    <div class="card-tools">
                        <a href="#" data-toggle="modal" data-target="#exampleModal_lead" class="btn btn-success btn-sm"><i class="fa fa-plus" aria-hidden="true"></i> Add Lead</a>
                        <a href="#" data-toggle="modal" data-target="#assignModal_lead" class="btn btn-warning btn-sm"><i class="fa fa-plus" aria-hidden="true"></i> Assign Agent</a>
                        <a href="#" data-toggle="modal" data-target="#exampleModal_bulk_lead" class="btn btn-success btn-sm"><i class="fa fa-upload" aria-hidden="true"></i> Upload Bulk Lead</a>
                        <a href="<?php echo base_url(); ?>back/format/sample_format.csv" download="" class="btn btn-info btn-sm"><i class="fa fa-download" aria-hidden="true"></i> Download Smaple</a>
                    </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                    <table id="example1" class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th><input type="checkbox" id="selectAll"></th>
                                <th>ID</th>
                                <th width="15%">Name</th>
                                <th>Extra Details</th>
                                <th width="15%">Package</th>
                                <th>Conversation</th>
                                <?php if (user()->user_role == 'Admin') : ?>
                                    <th width="15%">Assign To</th>
                                <?php endif; ?>
                                <th>Status</th>
                                <th width="5%"></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $i = 1;
                            foreach ($all_data as $lead) : ?>
                                <tr>
                                    <td>
                                        <input type="checkbox" class="leadCheckbox" value="<?php echo $lead->lead_id; ?>">
                                    </td>
                                    <td>
                                        <?php echo $i ?>
                                    </td>
                                    <td>
                                        <?php echo $lead->lead_name ?>
                                    </td>
                                    <td>
                                        <?php if ($lead->lead_mobile) : ?>
                                            <i class="fa fa-phone"></i> <b><?php echo $lead->lead_mobile; ?></b>
                                        <?php endif; ?>
                                        <?php if ($lead->lead_email) : ?>
                                            <br />
                                            <i class="fa fa-envelope"></i> <b><?php echo $lead->lead_email; ?></b>
                                        <?php endif; ?>
                                        <?php if ($lead->lead_address) : ?>
                                            <br />
                                            <i class="fa fa-map-marker"></i> <b><?php echo $lead->lead_address; ?></b>
                                        <?php endif; ?>
                                        <br />
                                        <i class="fa fa-calendar"></i> <b><?php echo date('d-m-Y', strtotime($lead->lead_date)) ?></b>
                                        <?php if ($lead->lead_source) : ?>
                                            <br />
                                            <i class="fa fa-bullseye"></i> <b><?php echo $lead->lead_source; ?></b>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php echo $lead->package_title; ?>
                                    </td>
                                    <td class="text-center">
                                        <button data-toggle="modal" data-target="#exampleModalView<?php echo $lead->lead_id ?>" class="btn btn-warning btn-xs"><i class="fa fa-phone"></i>&nbsp; Conversation</button>
                                        <div class="modal fade" id="exampleModalView<?php echo $lead->lead_id ?>" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="exampleModalLabel">View Call Conversation</h5>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <?php foreach (json_decode($lead->lead_comment_and_date) as $key => $comment) : ?>
                                                            <div class="form-group">
                                                                <label for="message-text" class="col-form-label"><i class="fa fa-clock"></i>&nbsp;<?php echo $comment->date; ?> <?php if ($comment->comment_mode) : ?>|| Mode : <b><?php echo $comment->comment_mode; ?></b><?php endif; ?></label>
                                                                <p><?php echo $comment->comment; ?></p>
                                                                <?php if ($comment->next_follow_date) : ?>
                                                                    <label for="message-text" class="col-form-label"><i class="fa fa-clock"></i> Next Follow Up Date &nbsp;<?php echo date('d-m-Y h:i a', strtotime($comment->next_follow_date)) ?></label>
                                                                <?php endif; ?>
                                                                <hr />
                                                            </div>
                                                        <?php endforeach; ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <br />
                                        <br />
                                        <!-- <button style="background-color: #25D366;border-color:#25D366" data-toggle="modal" data-target="#exampleModalWpView<?php echo $lead->lead_id ?>" class="btn btn-success btn-xs "><i class="fa fa-whatsapp"></i>&nbsp; Conversation</button>
                                        <div class="modal fade" id="exampleModalWpView<?php echo $lead->lead_id ?>" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="exampleModalLabel">View Whatsapp Conversation</h5>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <?php foreach (json_decode($lead->lead_wp_conv_and_date) as $key => $wp_comment) : ?>
                                                            <div class="form-group">
                                                                <label for="message-text" class="col-form-label"><i class="fa fa-clock"></i>&nbsp;<?php echo $wp_comment->date; ?></label>
                                                                <p><?php echo $wp_comment->comment; ?></p>

                                                                <hr />
                                                            </div>
                                                        <?php endforeach; ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div> -->
                                        <a href="tel:<?php echo $lead->lead_mobile; ?>" class="btn btn-info btn-xs"><i class="fa fa-phone"></i>&nbsp; Call Now</a>
                                        <br />
                                        <br />
                                        <a target="_blank" style="background-color: #25d366 ;color:#fff" href="https://api.whatsapp.com/send?phone=91<?php echo $lead->lead_mobile; ?>" class="btn  btn-xs"><i class="fa fa-whatsapp"></i>&nbsp; Whatsapp</a>
                                    </td>
                                    <?php if (user()->user_role == 'Admin') : ?>
                                        <td>
                                            <?php echo
                                            form_open(base_url() . 'admin/lead/assign_user/' . $lead->lead_id);
                                            ?>
                                            <select class="form-control" name="lead_employee_id" required>
                                                <option value="">Select A Employee</option>
                                                <?php foreach ($all_users as $key => $user) : ?>
                                                    <option <?php if ($lead->lead_employee_id == $user->user_id) {
                                                                echo 'selected';
                                                            } ?> value="<?php echo $user->user_id; ?>"><?php echo $user->user_name; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <div class="text-right">
                                                <button type="submit" class="btn btn-info btn-sm mt-1">Save</button>
                                            </div>
                                            <?php echo form_close(); ?>
                                        </td>
                                    <?php endif; ?>
                                    <td>
                                        <?php if ($lead->lead_status == 0) : ?>
                                            <span class="badge badge-warning">New</span>
                                        <?php elseif ($lead->lead_status == 1) : ?>
                                            <span class="badge badge-info">Apointment Process</span>
                                        <?php elseif ($lead->lead_status == 2) : ?>
                                            <span class="badge badge-success">Admited</span>
                                        <?php elseif ($lead->lead_status == 3) : ?>
                                            <span class="badge badge-danger">Wrong Number</span>
                                        <?php elseif ($lead->lead_status == 5) : ?>
                                            <span class="badge badge-danger">Junk Lead</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="text-right py-0 align-middle">
                                        <div class="mt-3"></div>
                                        <div class="btn-group-sm">
                                            <?php if ($lead->lead_status != 2) : ?>
                                                <a title="Lead Status" onclick="change_status(<?php echo $lead->lead_id  ?>, <?php echo $lead->lead_status  ?>)" href="#" class="btn btn-info"><i class="fas fa-question-circle"></i></a>

                                                <!-- <a title="Send Whatsapp" href="#" onclick="open_whatsapp_model('<?php echo $lead->lead_mobile  ?>', <?php echo $lead->lead_id  ?>)" class="btn btn-info mt-3" style="background-color:#25D366; border-color:#25D366"><i class="fa fa-whatsapp"></i></a> -->

                                                <a title="Add Conversation" href="#" onclick="open_conversition_model(<?php echo $lead->lead_id  ?>)" class="btn btn-secondary mt-3"><i class="fas fa-plus"></i></a>
                                            <?php endif; ?>
                                            <?php if (user()->user_role == 'Admin') : ?>
                                                <a title="Delete" href="<?php echo base_url(); ?>/admin/lead/delete_lead/<?php echo $lead->lead_id  ?>" class="btn btn-danger mt-3"><i class="fas fa-trash"></i></a>
                                            <?php endif; ?>
                                        </div>
                                        <div class="mb-3"></div>
                                    </td>
                                </tr>
                                <?php $i++; ?>
                            <?php endforeach; ?>
                        </tbody>
                    </table>

                </div>
            </div>
        </div>
    </section>
</div>

<div class="modal fade" id="assignModal_lead" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content ">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Assign Agent</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <?php echo
            form_open('admin/lead/assign_agent');
            ?>
            <div class="modal-body">
                <div class="container">
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group">
                                <label for="recipient-name" class="col-form-label">Select Agent <span class="text-danger">*</span></label>
                                <select class="form-control" placeholder="Enter Lead Full Name" name="lead_employee_id" required>
                                    <option value="">Select From List</option>
                                    <?php foreach ($all_users as $key => $user) : ?>
                                        <option value="<?php echo $user->user_id; ?>"><?php echo $user->user_name; ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                        <input id="assign_lead_id" name="lead_id" value="" type="hidden">
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-info">Save</button>
            </div>
            <?php echo
            form_close();
            ?>
        </div>
    </div>
</div>

<div class="modal fade" id="exampleModal_lead" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content ">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Add New Lead</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <?php echo
            form_open('admin/lead/add_lead');
            ?>
            <div class="modal-body">
                <div class="container">
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group">
                                <label for="recipient-name" class="col-form-label">Full Name <span class="text-danger">*</span></label>
                                <input class="form-control" placeholder="Enter Lead Full Name" name="lead_name" required>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label for="recipient-name" class="col-form-label">Mobile <span class="text-danger">*</span></label>
                                <input class="form-control" placeholder="Enter Lead Name" name="lead_mobile" required title="Please enter a 10-digit mobile number" pattern="[1-9]{1}[0-9]{9}" type="text">
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label for="recipient-name" class="col-form-label">Email </label>
                                <input class="form-control" type="email" placeholder="Enter Lead Email" name="lead_email" type="email" pattern="[a-z0-9._%+\-]+@[a-z0-9.\-]+\.[a-z]{2,}$" title="Please Enter Valid Email ID">
                            </div>
                        </div>

                        <div class="col-sm-6">
                            <div class="form-group">
                                <label for="recipient-name" class="col-form-label">Service <span class="text-danger">*</span> </label>
                                <select required class="form-control" placeholder="Enter Lead Source" name="lead_package_id">
                                    <option value="">Select From List</option>
                                    <?php foreach ($all_service as $key => $product) : ?>
                                        <option value="<?php echo $product->package_id; ?>"><?php echo $product->package_title; ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-info">Save</button>
            </div>
            <?php echo
            form_close();
            ?>
        </div>
    </div>
</div>

<div class="modal fade" id="status" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Update Status</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <?php echo form_open(base_url() . 'admin/lead/change_lead_status'); ?>
            <div class="modal-body">
                <div class="form-group">
                    <label for="recipient-name" class="col-form-label">Select Status</label>
                    <select type="text" class="form-control" id="lead_status" name="lead_status">
                    <option value="0">New</option>
                        <option value="1">Apointment Process</option>
                        <option value="2">Admited</option>
                        <option value="3">Wrong Number</option>
                        <option value="5">Junk Lead</option>
                    </select>
                </div>
            </div>
            <input type="hidden" class="form-control" id="lead_id_2" name="lead_id">
            <div class="modal-footer">
                <button type="submit" onclick="return confirm('Are you sure?')" class="btn btn-info">Update</button>
            </div>
            <?php echo form_close(); ?>
        </div>
    </div>
</div>

<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Add Conversation</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <?php echo
            form_open(base_url() . 'admin/lead/add_new_call_conversation');
            ?>
            <div class="modal-body">
                <div class="form-group">
                    <label for="message-text" class="col-form-label">Select Conversation Mode <span>*</span></label>
                    <select onchange="check_conv_mode(this.value)" class="form-control" name="comment_mode" required>
                        <option value="">Select</option>
                        <option value="Call Connected">Call Connected</option>
                        <option value="Call Ringing">Call Ringing</option>
                        <option value="Phone Switched Off">Phone Switched Off</option>
                        <option value="Call Busy">Call Busy</option>
                        <option value="Appointment Confirmed">Appointment Confirmed</option>
                        <option value="Appointment Hold">Appointment Hold</option>
                        <option value="Appointment Postponed">Appointment Postponed</option>
                        <option value="Consulted">Consulted</option>
                        <option value="Admission Hold">Admission Hold</option>
                        <option value="Fees Issue">Fees Issue</option>
                        <option value="Not Visited">Not Visited</option>
                        <option value="Consulted">Consulted</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="message-text" class="col-form-label">Conversation <span>*</span></label>
                    <textarea class="form-control" rows="10" id="message-text" name="lead_comment_and_date" required></textarea>
                </div>
                <div class="form-group followUpDateDiv">
                    <label for="message-text" class="col-form-label">Next Follow Up Date & Time <span class="text-danger">*</span></label>
                    <input class="form-control" id="followUpDateFiled" type="datetime-local" name="lead_comment_and_date_and_time">
                </div>
            </div>
            <input type="hidden" id="lead_id" required name="lead_id">
            <div class="modal-footer">
                <button type="submit" class="btn btn-info">Save</button>
            </div>
            <?php echo form_close(); ?>
        </div>
    </div>
</div>

<div class="modal fade" id="exampleModal_bulk_lead" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-md" role="document">
        <div class="modal-content ">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Upload Bulk Lead</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form id="csvUploadForm" class="mb-4" enctype="multipart/form-data">
                <div class="modal-body">
                    <div class="container">
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group">
                                    <label for="recipient-name" class="col-form-label">Upload File (CSV, xlsx)<span class="text-danger">*</span></label>
                                    <input class="form-control" type="file" placeholder="Enter Lead Name" name="uploadFile" required>
                                </div>
                            </div>
                            <div class="col-sm-12">
                                <div id="uploadStatus"></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-info" id="uploadButton">Upload</button>
                </div>
            </form>
        </div>
    </div>
</div>


<div class="modal fade" id="whatsappModel" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Send Whatsapp Message</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <?php echo form_open(base_url() . 'admin/lead/send_whatsapp_message'); ?>
            <div class="modal-body">
                <div class="form-group">
                    <label for="recipient-name" class="col-form-label">Message</label>
                    <textarea type="text" class="form-control" name="message" required rows="10"></textarea>
                </div>
            </div>
            <input type="hidden" class="form-control" id="mobile_no" name="mobile_no">
            <input type="hidden" class="form-control" id="main_lead_id" name="lead_id">
            <div class="modal-footer">
                <button type="submit" class="btn btn-info">Send</button>
            </div>
            <?php echo form_close(); ?>
        </div>
    </div>
</div>

<style>
    .followUpDateDiv {
        /* display: none; */
    }
</style>
<script>
     $(document).ready(function () {
        let selectedIds = [];

        // When any checkbox is clicked
        $('.leadCheckbox').on('change', function () {
            const leadId = $(this).val();

            if ($(this).is(':checked')) {
                // Add to array if not already present
                if (!selectedIds.includes(leadId)) {
                    selectedIds.push(leadId);
                }
            } else {
                // Remove from array
                selectedIds = selectedIds.filter(id => id !== leadId);
            }

            // Update the hidden input with comma-separated values
            $('#assign_lead_id').val(selectedIds.join(','));
        });

        // Optional: handle 'select all' checkbox
        $('#selectAll').on('change', function () {
            const isChecked = $(this).is(':checked');

            $('.leadCheckbox').prop('checked', isChecked).trigger('change');
        });
    });
    $('#csvUploadForm').on('submit', function(event) {
        event.preventDefault(); // Prevent default form submission


        let formData = new FormData(this);
        formData.append("table", $("#tableSelect").val());

        $.ajax({
            url: "<?= base_url('admin/lead/add_lead_bulk') ?>",
            type: "POST",
            data: formData,
            contentType: false,
            processData: false,
            dataType: "json",
            beforeSend: function() {
                $("#uploadStatus").html('<div class="alert alert-info">Processing CSV... Please wait.</div>');
                $('#uploadButton').attr('disabled', true);
            },
            success: function(response) {
                if (response.inserted || response.updated || response.failed || response.total_rows || response.column_mismatches || response.execution_time) {
                    $("#uploadStatus").html(`
                    <div class="alert alert-success">
                        <strong>Upload Completed:</strong><br>
                        Inserted: ${response.inserted} | Updated: ${response.updated} | Failed: ${response.failed} | Total Row: ${response.total_rows} | Column Mismatches: ${response.column_mismatches} | Execution Time: ${response.execution_time}
                    </div>
                `);
                } else {
                    $("#uploadStatus").html('<div class="alert alert-warning">Upload completed, but no records were processed.</div>');
                }

                $('#uploadButton').attr('disabled', false);
                $("#example1").load(window.location.href + " #example1");

            },
            error: function(xhr) {
                console.log(xhr.responseText);
                let errorMessage = "Upload failed. Please try again.";

                if (xhr.status === 400) {
                    errorMessage = xhr.responseJSON.message || "Invalid request. Check your input.";
                } else if (xhr.status === 500) {
                    errorMessage = "Server error occurred. Please try again later.";
                }

                $("#uploadStatus").html(`<div class="alert alert-danger">${errorMessage}</div>`);
                $('#uploadButton').attr('disabled', false);
            }
        });
    });

    function check_conv_mode(e) {
        // if (e == 'Busy – Call Later') {
        //     $('.followUpDateDiv').show();
        //     $('#followUpDateFiled').attr('required', true);
        // } else if (e == 'Follow-Up Scheduled') {
        //     $('.followUpDateDiv').show();
        //     $('#followUpDateFiled').attr('required', true);
        // } else if (e == 'Requested Callback Later') {
        //     $('.followUpDateDiv').show();
        //     $('#followUpDateFiled').attr('required', true);
        // } else if (e == 'Requested Callback Later') {
        //     $('.followUpDateDiv').show();
        //     $('#followUpDateFiled').attr('required', true);
        // } else {
        //     $('.followUpDateDiv').hide();
        //     $('#followUpDateFiled').attr('required', false);
        // }
    }

    function change_status(e, status) {
        $('#status').modal('show');
        $('#lead_id_2').val(e);
        $('#lead_status').val(status);
    }

    function open_conversition_model(e) {
        $('#exampleModal').modal('show');
        $('#lead_id').val(e);
    }

    function open_whatsapp_model(e, lead_id) {
        $('#whatsappModel').modal('show');
        $('#mobile_no').val(e);
        $('#main_lead_id').val(lead_id)
    }
</script>
<style>
    .sell_filed {
        display: none;
    }
</style>