<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h4>All Slider</h4>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo base_url() ?>admin/dashboard">Home</a></li>
                        <li class="breadcrumb-item"><a href="#">Front Setting</a></li>
                        <li class="breadcrumb-item active">All Slider</li>
                    </ol>
                </div>
            </div>
        </div>
        <!-- /.container-fluid -->
    </section>


    <section class="content">
        <div class="container-fluid">
            <div class="card card-default">
                <div class="card-header">
                    <h3 class="card-title">View All Slider</h3>
                    <div class="card-tools">
                        <a href="#" class="btn btn-success btn-sm" data-toggle="modal" data-target="#exampleModal"><i class="fa fa-plus" aria-hidden="true"></i> Add Slider</a>
                    </div>
                </div>
                <div class="card-body">
                    <table id="example1" class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Image</th>
                                <th>Heading</th>
                                <th>Sub-Heading</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $i = 1;
                            foreach ($all_data as $data) : ?>
                                <tr>
                                    <td><?php echo $i; ?></td>
                                    <td><img src="<?php echo base_url(); ?><?php echo $data->slider_image; ?>" width="100"></td>
                                    <td><?php echo $data->slider_heading; ?></td>
                                    <td><?php echo $data->slider_sub_heading; ?></td>
                                    <td>
                                        <a class="btn btn-success btn-sm" href="<?php echo base_url(); ?>admin/front_setting/edit_slider/<?php echo $data->slider_id; ?>"><i class="fas fa-edit"></i></a>

                                        <a class="btn btn-danger btn-sm" href="<?php echo base_url(); ?>admin/front_setting/delete_slider/<?php echo $data->slider_id; ?>"><i class="fas fa-trash"></i></a>
                                    </td>
                                </tr>
                                <?php $i++; ?>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </section>

</div>



<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content ">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Add New Slider</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <?php echo
            form_open_multipart('admin/front_setting/add_slider');
            ?>
            <div class="modal-body">
                <div class="container">
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group">
                                <label for="recipient-name" class="col-form-label">Sub-Heading <span class="text-danger">*</span></label>
                                <input class="form-control" placeholder="Enter Slider Sub-Heading" name="slider_sub_heading" required>
                            </div>
                        </div>
                        <div class="col-sm-12">
                            <div class="form-group">
                                <label for="recipient-name" class="col-form-label">Heading <span class="text-danger">*</span></label>
                                <input class="form-control" placeholder="Enter Slider Heading" name="slider_heading" required>
                            </div>
                        </div>
                        <div class="col-sm-12">
                            <div class="form-group">
                                <label for="recipient-name" class="col-form-label">Image <span class="text-danger">*</span></label>
                                <input type="file" class="form-control" placeholder="Enter Slider Heading" name="slider_image" required>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-info">Save</button>
            </div>
            <?php echo
            form_close();
            ?>
        </div>
    </div>
</div>