<div class="content-wrapper">
  <!-- Content Header (Page header) -->
  <div class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1 class="m-0 text-dark">All Gallery</h1>
        </div><!-- /.col -->
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="<?php echo base_url() ?>admin/admin/dashboard">Dashboard</a></li>
            <li class="breadcrumb-item"><a href="#">Front Setting</a></li>
            <li class="breadcrumb-item active">All Gallery</li>

          </ol>
        </div><!-- /.col -->
      </div><!-- /.row -->
    </div><!-- /.container-fluid -->
  </div>
  <!-- /.content-header -->

  <section class="content">
    <div class="container-fluid">
      <div class="card card-default">
        <div class="card-header">
          <h3 class="card-title">View All Gallery</h3>
          <div class="card-tools">
            <a href="#" class="btn btn-success btn-sm" data-toggle="modal" data-target="#exampleModal"><i class="fa fa-plus" aria-hidden="true"></i> Add Gallery</a>
          </div>
        </div>
        <!-- /.card-header -->
        <div class="card-body">
          <table id="example1" class="table table-bordered table-striped">
            <thead>
              <tr>
                <th>ID</th>
                <th>Content</th>
                <th>Name</th>
                <th>Type</th>
                <th>Action</th>
              </tr>
            </thead>
            <tbody>
              <?php $i = 1;
              foreach ($all_data as $data): ?>
                <tr>
                  <td><?php echo $i; ?></td>
                  <td>
                    <?php if ($data->gallery_type == 'photo'): ?>
                      <img src="<?php echo base_url($data->gallery_content); ?>" width="70px">
                    <?php elseif ($data->gallery_type == 'video'): ?>
                      <?php
                      // Check if it's a YouTube link and extract the video ID
                      preg_match('/(?:youtu\.be\/|youtube\.com\/(?:watch\?v=|embed\/))([^\&\?\/]+)/', $data->gallery_content, $matches);
                      if (!empty($matches[1])) {
                        $video_id = $matches[1];
                        echo '<iframe width="150" height="75" src="https://www.youtube.com/embed/' . $video_id . '" frameborder="0" allowfullscreen></iframe>';
                      } else {
                        echo 'Invalid video URL';
                      }
                      ?>
                    <?php endif; ?>
                  </td>

                  <td><?php echo $data->gallery_name ?></td>
                  <td><?php echo ucfirst($data->gallery_type); ?></td>
                  <td>
                    <!-- <a class="btn btn-success btn-sm" href="<?php echo base_url(); ?>admin/front_setting/edit_gallety/<?php echo $data->gallery_id  ?>"><i class="fas fa-edit"></i></a> -->
                    <a class="btn btn-danger btn-sm" href="<?php echo base_url(); ?>admin/front_setting/delete_gallery/<?php echo $data->gallery_id  ?>"><i class="fas fa-trash"></i></a>
                  </td>
                </tr>
                <?php $i++; ?>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      </div>
    </div><!--/. container-fluid -->
  </section>
  <!-- /.content -->
</div>

<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content ">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Add New Gallery</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <?php echo
      form_open_multipart('admin/front_setting/add_gallery');
      ?>
      <div class="modal-body">
        <div class="container">
          <div class="row">
            <div class="col-sm-12">
              <div class="form-group">
                <label for="recipient-name" class="col-form-label">Name <span class="text-danger">*</span></label>
                <input class="form-control" placeholder="Enter Testimonial Name" name="gallery_name" required>
              </div>
            </div>
            <div class="col-sm-12">
              <div class="form-group">
                <label for="recipient-name" class="col-form-label">Type <span class="text-danger">*</span></label>
                <select onchange="set_content_type(this.value)" class="form-control" placeholder="Enter Testimonial Name" name="gallery_type" required>
                  <option value="">Select From List</option>
                  <option value="photo">Image</option>
                  <option value="video">Video</option>
                </select>
              </div>
            </div>
            <div class="col-sm-12" id="upload_type"></div>

          </div>
        </div>
      </div>
      <div class="modal-footer">
        <button type="submit" class="btn btn-info">Save</button>
      </div>
      <?php echo
      form_close();
      ?>
    </div>
  </div>
</div>
<script>
  function set_content_type(e) {
    let htmlContent = '';

    if (e === 'photo') {
      htmlContent = `
        <div class="form-group">
          <label for="gallery_content" class="col-form-label">
            Upload Image <span class="text-danger">*</span>
          </label>
          <input class="form-control" type="file" name="gallery_content" required>
        </div>`;
    } else {
      htmlContent = `
        <div class="form-group">
          <label for="gallery_content" class="col-form-label">
            Youtube URL <span class="text-danger">*</span>
          </label>
          <input class="form-control" type="text" placeholder="Enter Youtube URL" name="gallery_content" required>
        </div>`;
    }

    $('#upload_type').html(htmlContent);
  }
</script>