<?php

use App\Models\TourModel;
use App\Models\UserModel;

$user_data = new UserModel();
$tour = new TourModel();
$leadUsers  = $user_data->getLeadAssignUsers();

$roles = array_column($leadUsers, 'user_role');
$uniqueRoles = array_unique($roles);

if (user()->user_role == 'Admin'):
?>
    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0">Dashboard</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#">Home</a></li>
                            <li class="breadcrumb-item active">Dashboard</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-lg-3 col-6">
                        <div class="small-box bg-success">
                            <div class="inner">
                                <h3>
                                    <?php
                                    $db = db_connect();
                                    echo $query = $db->table('users')
                                        ->where('user_role', 'Clinic')
                                        ->get()
                                        ->getNumRows();

                                    ?>
                                    
                                </h3>
                                <p>Total Clinics</p>
                            </div>
                            <div class="icon">
                                <i class="fa fa-home"></i>
                            </div>
                            <a href="<?php echo base_url(); ?>admin/booking/all_bookings" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
                        </div>
                    </div>
                    <div class="col-lg-3 col-6">
                        <div class="small-box bg-primary">
                            <div class="inner">
                                <h3>
                                    <?php
                                    $db = db_connect();
                                    echo $query = $db->table('package')
                                        ->get()
                                        ->getNumRows();

                                    ?>
                                </h3>
                                <p>Total Service</p>
                            </div>
                            <div class="icon">
                                <i class="fa fa-suitcase"></i>
                            </div>
                            <a href="<?php echo base_url(); ?>admin/tour/package" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
                        </div>
                    </div>
                    <div class="col-lg-3 col-6">
                        <div class="small-box bg-info">
                            <div class="inner">
                                <h3>
                                    <?php

                                    if (!empty($leadUsers)) {
                                        echo count($leadUsers);
                                    } else {
                                        echo 0;
                                    }
                                    ?>
                                </h3>
                                <p>Total Telecaller</p>
                            </div>
                            <div class="icon">
                                <i class="fa fa-users"></i>
                            </div>
                            <a href="<?php echo base_url(); ?>admin/tour/destinations" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
                        </div>
                    </div>
                    <div class="col-lg-3 col-6">
                        <div class="small-box bg-success">
                            <div class="inner">
                                <h3>
                                    <?php

                                    $db = db_connect();
                                    echo $query = $db->table('lead')
                                        ->where('date(lead_date)', date('Y-m-d'))
                                        ->get()
                                        ->getNumRows();

                                    ?>
                                </h3>
                                <p>Today Leads</p>
                            </div>
                            <div class="icon">
                                <i class="fa fa-phone"></i>
                            </div>
                            <a href="<?php echo base_url(); ?>admin/booking/all_bookings" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
                        </div>
                    </div>
                    <div class="col-lg-3 col-6">
                        <div class="small-box bg-success">
                            <div class="inner">
                                <h3>
                                    <?php

                                    $db = db_connect();
                                    echo $query = $db->table('lead')
                                        ->get()
                                        ->getNumRows();

                                    ?>
                                </h3>
                                <p>Total Leads</p>
                            </div>
                            <div class="icon">
                                <i class="fa fa-phone"></i>
                            </div>
                            <a href="<?php echo base_url(); ?>admin/booking/all_bookings" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
                        </div>
                    </div>
                    <div class="col-lg-3 col-6">
                        <div class="small-box bg-warning">
                            <div class="inner">
                                <h3>
                                    <?php
                                    // $db = db_connect();
                                    // echo $query = $db->table('blog')
                                    //     ->get()
                                    //     ->getNumRows();

                                    ?>
                                    0
                                </h3>
                                <p>Appointment Confirms</p>
                            </div>
                            <div class="icon">
                                <i class="fa fa-book"></i>
                            </div>
                            <a href="<?php echo base_url(); ?>admin/blog/all_blog" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
                        </div>
                    </div>

                    <div class="col-lg-3 col-6">
                        <div class="small-box bg-secondary">
                            <div class="inner">
                                <h3>
                                    <?php
                                    $db = db_connect();
                                    echo $query = $db->table('blog')
                                        ->get()
                                        ->getNumRows();

                                    ?>
                                </h3>
                                <p>Total Blogs</p>
                            </div>
                            <div class="icon">
                                <i class="fas fa-blog"></i>
                            </div>
                            <a href="<?php echo base_url(); ?>admin/blog/all_blog" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
                        </div>
                    </div>
                    <div class="col-lg-3 col-6">
                        <div class="small-box bg-primary">
                            <div class="inner">
                                <h3>
                                    <?php

                                    $db = db_connect();
                                    echo $query = $db->table('users')
                                        ->where('user_is_employee', 1)
                                        ->get()
                                        ->getNumRows();

                                    ?>
                                </h3>
                                <p>Total Employee</p>
                            </div>
                            <div class="icon">
                                <i class="fa fa-users"></i>
                            </div>
                            <a href="<?php echo base_url(); ?>admin/blog/all_blog" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
                        </div>
                    </div>

                </div>
            </div>
        </section>
    </div>
<?php

elseif (in_array(user()->user_role, $uniqueRoles)): ?>
    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0">Dashboard</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#">Home</a></li>
                            <li class="breadcrumb-item active">Dashboard</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <section class="content">
            <div class="container-fluid">
                <?php
                function getBoxColor($label)
                {
                    $colors = [
                        'Total Lead' => 'bg-primary',
                        'This Month Leads' => 'bg-info',
                        'This Months Confirms' => 'bg-success',
                        'Todays Follow-ups' => 'bg-warning',
                        'Appointment Confirmed' => 'bg-success',
                        'Appointment Process' => 'bg-secondary',
                        'Lost Leads' => 'bg-danger',
                        'Junk Leads' => 'bg-dark',
                    ];
                    return $colors[$label] ?? 'bg-light'; // fallback color
                }
                
                $today = date('Y-m-d'); // Get today's date
                $todayFollowupCount = 0;

                $allLead = $tour->get_all_lead();
                $thisMonthLead = $tour->get_all_this_month_lead();
                $leadConfirm = $tour->get_all_count_assign_lead_by_status_and_id(2);
                $leadProcess = $tour->get_all_count_assign_lead_by_status_and_id(1);
                $leadJunk = $tour->get_all_count_assign_lead_by_status_and_id(5);
                
                foreach ($allLead as $lead) {
                    if (!empty($lead->lead_comment_and_date)) {
                        $comments = json_decode($lead->lead_comment_and_date);
                        foreach ($comments as $comment) {
                            // Extract date part from next_follow_date
                            $followDate = !empty($comment->next_follow_date) ? substr($comment->next_follow_date, 0, 10) : '';
                            if ($followDate === $today) {
                                $todayFollowupCount++;
                                break; // Count each lead only once
                            }
                        }
                    }
                }

                ?>

                <div class="row">
                    <div class="col-lg-3 col-6">
                        <div class="small-box <?php echo getBoxColor('Total Lead'); ?>">
                            <div class="inner">
                                <h3><?php echo count($allLead); ?></h3>
                                <p>Total Lead</p>
                            </div>
                            <div class="icon">
                                <i class="fa fa-phone"></i>
                            </div>
                            <a href="<?php echo base_url(); ?>admin/lead/all_lead" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
                        </div>
                    </div>

                    <div class="col-lg-3 col-6">
                        <div class="small-box <?php echo getBoxColor('This Month Leads'); ?>">
                            <div class="inner">
                                <h3><?= !empty($thisMonthLead) ? count($thisMonthLead) : 0; ?></h3>
                                <p>This Month Leads</p>
                            </div>
                            <div class="icon">
                                <i class="fa fa-calendar"></i>
                            </div>
                            <a href="<?php echo base_url(); ?>admin/booking/all_lead" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
                        </div>
                    </div>

                    <div class="col-lg-3 col-6">
                        <div class="small-box <?php echo getBoxColor('This Months Confirms'); ?>">
                            <div class="inner">
                                <h3>0</h3>
                                <p>This Months Confirms</p>
                            </div>
                            <div class="icon">
                                <i class="fa fa-check"></i>
                            </div>
                            <a href="<?php echo base_url(); ?>admin/booking/all_lead" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
                        </div>
                    </div>

                    <div class="col-lg-3 col-6">
                        <div class="small-box <?php echo getBoxColor('Todays Follow-ups'); ?>">
                            <div class="inner">
                                <h3><?php echo $todayFollowupCount; ?></h3>
                                <p>Todays Follow-ups</p>
                            </div>
                            <div class="icon">
                                <i class="fa fa-calendar"></i>
                            </div>
                            <a href="<?php echo base_url(); ?>admin/booking/all_lead" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
                        </div>
                    </div>

                    <div class="col-lg-3 col-6">
                        <div class="small-box <?php echo getBoxColor('Appointment Confirmed'); ?>">
                            <div class="inner">
                                <h3><?php echo $leadConfirm; ?></h3>
                                <p>Appointment Confirmed</p>
                            </div>
                            <div class="icon">
                                <i class="fa fa-thumbs-up"></i>
                            </div>
                            <a href="<?php echo base_url(); ?>admin/booking/all_lead" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
                        </div>
                    </div>

                    <div class="col-lg-3 col-6">
                        <div class="small-box <?php echo getBoxColor('Appointment Process'); ?>">
                            <div class="inner">
                                <h3><?php echo $leadProcess; ?></h3>
                                <p>Appointment Process</p>
                            </div>
                            <div class="icon">
                                <i class="fa fa-hourglass-half"></i>
                            </div>
                            <a href="<?php echo base_url(); ?>admin/booking/all_lead" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
                        </div>
                    </div>

                    <div class="col-lg-3 col-6">
                        <div class="small-box <?php echo getBoxColor('Lost Leads'); ?>">
                            <div class="inner">
                                <h3>0</h3>
                                <p>Lost Leads</p>
                            </div>
                            <div class="icon">
                                <i class="fa fa-trash"></i>
                            </div>
                            <a href="<?php echo base_url(); ?>admin/booking/all_lead" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
                        </div>
                    </div>

                    <div class="col-lg-3 col-6">
                        <div class="small-box <?php echo getBoxColor('Junk Leads'); ?>">
                            <div class="inner">
                                <h3><?php echo $leadJunk; ?></h3>
                                <p>Junk Leads</p>
                            </div>
                            <div class="icon">
                                <i class="fa fa-exclamation-triangle"></i>
                            </div>
                            <a href="<?php echo base_url(); ?>admin/booking/all_lead" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
                        </div>
                    </div>
                </div>

            </div>
        </section>
    </div>
<?php endif; ?>