<?php

namespace App\Models;

use CodeIgniter\Model;

class UserModel extends Model
{
    protected $db;
    protected $users            = 'users';

    /**
     * User Information Start
     */

    function update_user_profile_details($data, $id)
    {
        return $this->db->table($this->users)
            ->where('user_id', $id)
            ->update($data);
    }

    function check_user_exists_or_not($filed, $value)
    {
        return $this->db->table($this->users)
            ->where($filed, $value)
            ->get()
            ->getNumRows();
    }

    // add new user data
    public function add_user($data)
    {
        $this->db->table($this->users)->insert($data);
        return $this->db->insertID(); // Get the last inserted ID
    }

    //update user
    function update_user($data, $id)
    {
        return $this->db->table($this->users)
            ->where('user_id', $id)
            ->update($data);
    }

    //delete user
    function delete_user($id)
    {
        return $this->db->table($this->users)
            ->where('user_id', $id)
            ->delete();
    }


    /**
     * User Information End
     */

    /**
     * Employee 
     */
    function get_all_employee()
    {
        return $this->db->table($this->users)
            ->where('user_is_employee', 1)
            ->get()
            ->getResult();
    }

    public function getLeadAssignUsers()
    {
        $db = \Config\Database::connect();

        // Step 1: Get all roles except 'Admin' and having permission "All Lead":1
        $builder = $db->table('role_permission');
        $builder->where('role_name !=', 'Admin');
        $builder->like('permission', '"All Lead":1', 'both');
        $query = $builder->get();
        $allData = $query->getResult();

        // Step 2: Collect role names
        $roles = [];
        foreach ($allData as $data) {
            $roles[] = $data->role_name;
        }

        // Step 3: Get users who match the collected roles
        if (!empty($roles)) {
            $builder = $db->table('users');
            $builder->select('user_name, user_id, user_role');
            $builder->where('user_is_employee', 1);
            $builder->whereIn('user_role', $roles);
            return $builder->get()->getResult();
        }

        return []; // Return empty array if no roles matched
    }

    /**
     * Clinic Section 
     */

     function get_all_clinic()
     {
         return $this->db->table($this->users)
             ->where('user_is_clinic', 1)
             ->get()
             ->getResult();
        
     }
}
