<?php

namespace App\Models;

use CodeIgniter\Model;

class TourModel extends Model
{
    protected $db;
    protected $destination  = 'destination';
    protected $package      = 'package';

    // package destination start
    public function get_all_destination()
    {
        return $this->db->table('destination')
            ->select('destination.*, COUNT(package.package_id) as package_count')
            ->join('package', 'package.package_destination = destination.destination_id', 'left')
            ->groupBy('destination.destination_id')
            ->get()
            ->getResult();
    }

    function get_all_destination_for_lead_page()
    {
        return $this->db->table('destination')
            ->select('destination_name, destination_id')
            ->get()
            ->getResult();
    }

    function add_destination($data)
    {
        return $this->db->table($this->destination)
            ->insert($data);
    }

    function get_destination_by_id($id)
    {
        return $this->db->table($this->destination)
            ->where('destination_id', $id)
            ->get()
            ->getRow();
    }

    function get_destination_by_slug($slug)
    {
        return $this->db->table($this->destination)
            ->where('destination_slug', $slug)
            ->get()
            ->getRow();
    }

    function update_destination($data, $id)
    {
        return $this->db->table($this->destination)
            ->where('destination_id', $id)
            ->update($data);
    }

    function delete_destination($id)
    {
        return $this->db->table($this->destination)
            ->where('destination_id', $id)
            ->delete();
    }

    function get_all_destination_with_package()
    {
        $all_data = $this->db->table($this->destination)
            ->select('destination_name, destination_id, destination_slug ')
            ->get()
            ->getResult();
        $final = [];

        foreach ($all_data as $key => $data) {
            $package = $this->db->table($this->package)
                ->select('package_title, package_slug, package_price, package_duration, package_front_description, package_photo')
                ->where('package_destination', $data->destination_id)
                ->get()
                ->getResult();
            $data->all_package = $package;

            array_push($final, $data);
        }

        return $final;
    }
    // package destination end

    // package section start



    function get_all_package_for_contact_us()
    {
        return $this->db->table($this->package)
            ->select('package_title, package_id')
            ->get()
            ->getResult();
    }

    function get_all_package()
    {
        return $this->db->table($this->package)
            ->join('destination', 'destination.destination_id = package.package_destination')
            ->get()
            ->getResult();
    }

    function get_all_package_for_home()
    {
        return $this->db->table($this->package)
            ->select('package_title, package_slug, package_front_description, package_id')
            ->get()
            ->getResult();
    }

    function get_all_package_by_destination($data)
    {
        return $this->db->table($this->package)
            ->join('destination', 'destination.destination_id = package.package_destination')
            ->where('package_destination', $data->destination_id)
            ->get()
            ->getResult();
    }


    function add_new_package($data)
    {
        return $this->db->table($this->package)
            ->insert($data);
    }

    function get_package_by_id($id)
    {
        return $this->db->table($this->package)
            // ->join('destination', 'destination.destination_id = package.package_destination')
            ->where('package_id', $id)
            ->get()
            ->getRow();
    }

    function get_package_by_slug($slug)
    {
        return $this->db->table($this->package)
            // ->join('destination', 'destination.destination_id = package.package_destination')
            ->where('package_slug', $slug)
            ->get()
            ->getRow();
    }

    function update_package($data, $id)
    {
        return $this->db->table($this->package)
            ->where('package_id', $id)
            ->update($data);
    }

    function delete_package($id)
    {
        return $this->db->table($this->package)
            ->where('package_id', $id)
            ->delete();
    }
    // package section end

    // Lead Section Start
    function submit_lead_form($data)
    {
        return $this->db->table('lead')
            ->insert($data);
    }

    function assign_user_lead($data, $id)
    {
        return $this->db->table('lead')
            ->where('lead_id', $id)
            ->update($data);
    }

    // function get_all_lead()
    // {
    //     if (user()->user_role == 'Admin') {
    //         return $this->db->table('lead')
    //             ->join('package', 'package.package_id = lead.lead_package_id')
    //             ->select('lead.*, package.package_title')
    //             ->get()
    //             ->getResult();
    //     } else {
    //         $user_id = user()->user_id;
    //         return $this->db->table('lead')
    //             ->join('package', 'package.package_id = lead.lead_package_id')
    //             ->select('lead.*, package.package_title')
    //             ->where('lead.lead_employee_id', $user_id)
    //             ->get()
    //             ->getResult();
    //     }
    // }

    public function get_all_lead($filters = [])
    {
        $builder = $this->db->table('lead')
            ->join('package', 'package.package_id = lead.lead_package_id')
            ->select('lead.*, package.package_title');

        if (user()->user_role != 'Admin') {
            $builder->where('lead.lead_employee_id', user()->user_id);
        }

        // Apply filters
        if (!empty($filters['start_date'])) {
            $builder->where('lead.lead_date >=', $filters['start_date'] . ' 00:00:00');
        }

        if (!empty($filters['end_date'])) {
            $builder->where('lead.lead_date <=', $filters['end_date'] . ' 23:59:59');
        }

        if (!empty($filters['service'])) {
            $builder->where('lead.lead_package_id', $filters['service']);
        }

        if (!empty($filters['status'])) {
            $builder->where('lead.lead_status', $filters['status']);
        }

        return $builder->get()->getResult();
    }


    function get_all_latest_lead_lead()
    {

        return $this->db->table('lead')
            ->join('package', 'package.package_id = lead.lead_package_id')
            ->select('lead.*, package.package_title')
            ->where('lead_employee_id', 0)
            ->get()
            ->getResult();
    }

    function get_all_assigned_lead()
    {
        return $this->db->table('lead')
            ->where('lead_employee_id !=', 0)
            ->join('package', 'package.package_id = lead.lead_package_id')
            ->select('lead.*, package.package_title')
            ->get()
            ->getResult();
    }
    
    function get_all_count_assign_lead_by_status_and_id($status)
    {
        $user_id = user()->user_id;
        return $this->db->table('lead')
            ->where('lead_employee_id', $user_id)
            ->where('lead_status', $status)
            ->get()
            ->getNumRows();
    }

    function get_all_this_month_lead()
    {
        if (user()->user_role == 'Admin') {
            return $this->db->table('lead')
                ->join('package', 'package.package_id = lead.lead_package_id')
                ->select('lead.*, package.package_title')
                ->where('MONTH(lead_date)', date('m'))
                ->where('YEAR(lead_date)', date('Y'))
                ->get()
                ->getResult();
        } else {
            $user_id = user()->user_id;
            return $this->db->table('lead')
                ->join('package', 'package.package_id = lead.lead_package_id')
                ->select('lead.*, package.package_title')
                ->where('MONTH(lead_date)', date('m'))
                ->where('YEAR(lead_date)', date('Y'))
                ->where('lead.lead_employee_id', $user_id)
                ->get()
                ->getResult();
        }
    }

    function change_lead_status($data, $id)
    {
        return $this->db->table('lead')
            ->where('lead_id', $id)
            ->update($data);
    }

    function delete_lead($id)
    {
        return $this->db->table('lead')
            ->where('lead_id', $id)
            ->delete();
    }

    public function getFieldNames($tableName)
    {
        if ($this->db->tableExists($tableName)) {
            $columns = $this->db->getFieldNames($tableName);
            return $columns;
        }
        return [];
    }

    public function findExistingRecord($tableName, $data)
    {
        $builder = $this->db->table($tableName);

        foreach ($data as $key => $column) {
            if ($column) {
                $builder->where($key, $column);
            }
        }

        $result = $builder->get()->getRowArray();

        if ($result) {
            $firstColumnName = array_key_first($result);
            return [$firstColumnName => $result[$firstColumnName]];
        }

        return null;
    }

    function updateData($tableName, $existing, $data)
    {
        $coloumName = array_key_first($existing);
        $coloumData = reset($existing);
        return $this->db->table($tableName)
            ->where($coloumName, $coloumData)
            ->update($data);
    }


    public function insertData($tableName, $data)
    {
        return $this->db->table($tableName)->insert($data);
    }
    // Lead Section End
}
