<?php

namespace App\Models;

use CodeIgniter\Model;

class SettingModel extends Model
{
    protected $setting = 'application_setting';
    protected $admin_menu = 'admin_menu';
    protected $role = 'role_permission';
    protected $contact_us = 'contact_us';
    protected $pass_log = 'forgot_password_log';

    protected $db;

    /**
     * Contact Us Start 
     */
    function submit_contact_form($data)
    {
        return $this->db->table($this->contact_us)
            ->insert($data);
    }
    /**
     * Contact Us End 
     */


    /**
     * Admin menu Start
     */
    function get_all_menu_and_sub_menu()
    {

        $all_menu = $this->db->table($this->admin_menu)
            ->orderBy('menu_order_by', 'ASC')
            ->where('is_main_menu', 1)
            ->get()
            ->getresult();
        $final = [];
        foreach ($all_menu as $key => $sub_menu) {

            $all_sub_menu = $this->db->table($this->admin_menu)
                ->where('main_menu_id', $sub_menu->menu_id)
                ->get()
                ->getResult();
            $sub_menu->sub_menu = $all_sub_menu;
            array_push($final, $sub_menu);
        };
        return $final;
    }

    public function getAllMenuAndSubMenu()
    {
        $db = \Config\Database::connect();

        // Get all main menus
        $menuTable = $db->table('admin_menu');
        $allMenus = $menuTable
            ->where('is_main_menu', 1)
            ->orderBy('menu_order_by', 'ASC')
            ->get()
            ->getResult();

        $final = [];

        foreach ($allMenus as $menu) {
            // Get all submenus for the current main menu
            $subMenuTable = $db->table('admin_menu');
            $subMenus = $subMenuTable
                ->where('main_menu_id', $menu->menu_id)
                ->get()
                ->getResult();

            // Attach submenus to the main menu
            $menu->sub_menu = $subMenus;

            // Add the menu to the final array
            $final[] = $menu;
        }

        return $final;
    }

    /**
     * Admin menu End
     */

    /**
     * Setting Section Start
     */
    function get_application_setting()
    {
        return $this->db->table($this->setting)
            ->where('app_id', 1)
            ->get()
            ->getRow();
    }

    function update_application_setting($data)
    {
        return $this->db->table($this->setting)
            ->where('app_id', 1)
            ->update($data);
    }

    function update_color($data)
    {
        return $this->db->table($this->setting)
            ->where('app_id', 1)
            ->update($data);
    }
    /**
     * Setting Section End
     */

    /**
     * Forgot Password Log Start
     */

    function add_forgot_password_log($data)
    {
        return $this->db->table($this->pass_log)
            ->insert($data);
    }

    function get_forgot_password_log($user_code, $user_password_code)
    {
        return $this->db->table($this->pass_log)
            ->where('password_user_code', $user_code)
            ->where('password_code', $user_password_code)
            ->get()
            ->getRow();
    }

    /**
     * Forgot Password Log End
     */
    /**
     * Role Permission
     */
    function get_all_role_permission()
    {
        return $this->db->table($this->role)
            // ->where('role_name', $user_role)
            ->get()
            ->getResult();
    }

    function get_role_permission()
    {
        return $this->db->table($this->role)
            ->where('role_name !=', 'Admin')
            ->get()
            ->getResult();
    }

    function get_permission_by_id($id)
    {
        return $this->db->table($this->role)
            ->where('id', $id)
            ->where('role_name !=', 'Admin')
            ->get()
            ->getRow();
    }

    function check_role_name_exists($name)
    {
        return $this->db->table($this->role)
            ->where('role_name', $name)
            ->get()
            ->getRow();
    }

    function permission_add($role_name)
    {
        $permissions = [];

        // Loop through submitted permission
        foreach ($_POST['permission'] as $menu_name => $submenu_permissions) {
            foreach ($submenu_permissions as $submenu_name => $value) {
                list($menu, $submenu) = explode('|', $submenu_name);
                $menu = str_replace("_", " ", $menu);
                $submenu = str_replace("_", " ", $submenu);

                $permissions[$menu][$submenu] = 1;
            }
        }

        $all_menu = $this->get_all_menu_and_sub_menu();
        // Loop through all menus to ensure all submenu permissions are set
        foreach ($all_menu as $menu) {
            $menu_name = $menu->menu_name;

            // Initialize submenu permissions for the menu
            if (!isset($permissions[$menu_name])) {
                $permissions[$menu_name] = [];
            }

            // Loop through submenus of the current menu
            foreach ($menu->sub_menu as $submenu) {
                $submenu_name = $submenu->menu_name;

                // Set the permission to 0 if not selected
                if (!isset($permissions[$menu_name][$submenu_name])) {
                    $permissions[$menu_name][$submenu_name] = 0;
                }
            }
        }

        // Output the permissions in the desired format
        $output = [];
        foreach ($permissions as $menu_name => $submenus) {
            $submenuStrings = [];
            foreach ($submenus as $submenu_name => $selected) {
                $submenuStrings[] = "\"{$submenu_name}\":{$selected}";
            }
            $output[] = "\"{$menu_name}\":{" . implode(', ', $submenuStrings) . "}";
        }

        // Output the result
        $data['permission'] = "{" . implode(', ', $output) . "}";
        $data['role_name'] = $role_name;

        return $this->db->table($this->role)
            ->insert($data);
    }

    function update_permission($id)
    {
        $permissions = [];

        // Loop through submitted permission
        foreach ($_POST['permission'] as $menu_name => $submenu_permissions) {
            foreach ($submenu_permissions as $submenu_name => $value) {
                list($menu, $submenu) = explode('|', $submenu_name);
                $menu = str_replace("_", " ", $menu);
                $submenu = str_replace("_", " ", $submenu);

                $permissions[$menu][$submenu] = 1;
            }
        }

        $all_menu = $this->get_all_menu_and_sub_menu();
        // Loop through all menus to ensure all submenu permissions are set
        foreach ($all_menu as $menu) {
            $menu_name = $menu->menu_name;

            // Initialize submenu permissions for the menu
            if (!isset($permissions[$menu_name])) {
                $permissions[$menu_name] = [];
            }

            // Loop through submenus of the current menu
            foreach ($menu->sub_menu as $submenu) {
                $submenu_name = $submenu->menu_name;

                // Set the permission to 0 if not selected
                if (!isset($permissions[$menu_name][$submenu_name])) {
                    $permissions[$menu_name][$submenu_name] = 0;
                }
            }
        }

        // Output the permissions in the desired format
        $output = [];
        foreach ($permissions as $menu_name => $submenus) {
            $submenuStrings = [];
            foreach ($submenus as $submenu_name => $selected) {
                $submenuStrings[] = "\"{$submenu_name}\":{$selected}";
            }
            $output[] = "\"{$menu_name}\":{" . implode(', ', $submenuStrings) . "}";
        }

        // Output the result
        $data['permission'] = "{" . implode(', ', $output) . "}";
        // $data['role_name'] = $this->input->post('role_name');

        return $this->db->table($this->role)
            ->where('id', $id)
            ->update($data);
    }

    function delete_permission($id)
    {
        return $this->db->table($this->role)
            ->where('id', $id)
            ->delete();
    }
    /**
     * Role Permission Section End
     */
}
