<?php

namespace App\Models;

use CodeIgniter\Model;

class FrontModel extends Model
{
    protected $about_us = 'about_us';
    protected $heading = 'front_heading_and_sub_heading';
    protected $slider = 'front_slider';
    protected $page = 'dynamic_pages';
    protected $testimonial = 'testimonial';
    protected $gallery = 'gallery';
    protected $db;

    /**
     * About US Section Start
     */
    function get_about_us()
    {
        return $this->db->table($this->about_us)
            ->where('about_id', 1)
            ->get()
            ->getRow();
    }

    function update_front_setting($data)
    {
        return $this->db->table($this->about_us)
            ->where('about_id', 1)
            ->update($data);
    }

    /**
     * About US Section End
     */

    /**
     * Slider Sction Start
     */
    function get_slider()
    {
        return $this->db->table($this->slider)
            ->get()
            ->getResult();
    }

    function get_slider_by_id($id)
    {
        return $this->db->table($this->slider)
            ->where('slider_id', $id)
            ->get()
            ->getRow();
    }

    function add_slider($data)
    {
        return $this->db->table($this->slider)
            ->insert($data);
    }

    function update_slider($data, $id)
    {
        return $this->db->table($this->slider)
            ->where('slider_id', $id)
            ->update($data);
    }

    function delete_slider($id)
    {
        return $this->db->table($this->slider)
            ->where('slider_id', $id)
            ->delete();
    }
    /**
     * Slider Sction End
     */

    /**
     * Dynamic Pages Start
     */

    function get_all_page()
    {
        return $this->db->table($this->page)
            ->get()
            ->getResult();
    }

    function get_page_by_id($id)
    {
        return $this->db->table($this->page)
            ->where('page_id', $id)
            ->get()
            ->getRow();
    }

    function get_page_by_slug($slug)
    {
        return $this->db->table($this->page)
            ->where('page_slug', $slug)
            ->get()
            ->getRow();
    }

    function add_new_page($data)
    {
        return $this->db->table($this->page)
            ->insert($data);
    }

    function update_page($data, $id)
    {
        return $this->db->table($this->page)
            ->where('page_id', $id)
            ->update($data);
    }

    function delete_page($id)
    {
        return $this->db->table($this->page)
            ->where('page_id', $id)
            ->delete();
    }
    /**
     * Dynamic Pages End
     */

    /**
     * Testimonial Section Start
     */
    function get_all_testimonials()
    {
        return $this->db->table($this->testimonial)
            ->get()
            ->getResult();
    }

    function get_testimonials_by_id($id)
    {
        return $this->db->table($this->testimonial)
            ->where('test_id', $id)
            ->get()
            ->getRow();
    }

    function add_new_testimonials($data)
    {
        return $this->db->table($this->testimonial)
            ->insert($data);
    }

    function update_testimonials($data, $id)
    {
        return $this->db->table($this->testimonial)
            ->where('test_id', $id)
            ->update($data);
    }

    function delete_testimonials($id)
    {
        return $this->db->table($this->testimonial)
            ->where('test_id', $id)
            ->delete();
    }
    /**
     * Testimonial Section End
     */

    /**
     * Gallery Section Start
     */

    function get_gallery_data_by_type($type)
    {
        return $this->db->table($this->gallery)
            ->where('gallery_type', $type)
            ->get()
            ->getResult();
    }

    function get_all_gallery()
    {
        return $this->db->table($this->gallery)
            ->get()
            ->getResult();
    }

    function get_gallery_by_id($id)
    {
        return $this->db->table($this->gallery)
            ->where('gallery_id', $id)
            ->get()
            ->getRow();
    }

    function add_gallery($data)
    {
        return $this->db->table($this->gallery)
            ->insert($data);
    }

    function update_gallery($data, $id)
    {
        return $this->db->table($this->gallery)
            ->where('gallery_id', $id)
            ->update($data);
    }

    function delete_gallery($id)
    {
        return $this->db->table($this->gallery)
            ->where('gallery_id', $id)
            ->delete();
    }

    /**
     * Gallery Section End
     */
}
