<?php

namespace App\Models;

use CodeIgniter\Model;

class BlogModel extends Model
{
    protected $db;
    protected $blog  = 'blog';


    function get_all_blog()
    {
        return $this->db->table($this->blog)
            ->get()
            ->getResult();
    }


    function get_top_10_blog()
    {
        return $this->db->table($this->blog)
            ->limit(10)
            ->orderBy('id', 'DESC')
            ->get()
            ->getResult();
    }

    function get_top_6_blog()
    {
        return $this->db->table($this->blog)
            ->select('title, title_slug, image, date')
            ->limit(6)
            ->orderBy('id', 'DESC')
            ->get()
            ->getResult();
    }

    function get_blog_by_id($id)
    {
        return $this->db->table($this->blog)
            ->where(['id' => $id])
            ->get()
            ->getRow();
    }

    function get_blog_by_slug($slug)
    {
        return $this->db->table($this->blog)
            ->where('title_slug', $slug)
            ->get()
            ->getRow();
    }

    function add_new_blog($data)
    {
        return $this->db->table($this->blog)->insert($data);
    }

    function update_blog_details($data, $id)
    {
        return $this->db->table($this->blog)
            ->where('id',  $id)
            ->update($data);
    }

    function delete_blog($id)
    {
        return $this->db->table($this->blog)
            ->where('id',  $id)
            ->delete();
    }
}
