<?php

namespace App\Models;

use CodeIgniter\Model;

class AuthModel extends Model
{
   protected $users = 'users';
   protected $role_permission = 'role_permission';
   protected $db;

   function get_user_by_mobile($mobile)
   {
       return $this->db->table($this->users)
       ->where('user_mobile', $mobile)
       ->get()
       ->getRow();
   }

   function get_user_by_mobile_and_password($mobile, $password)
   {
       return $this->db->table($this->users)
       ->where(['user_mobile'=> $mobile, 'user_password' => $password])
       ->get()
       ->getRow();
   }
   function update_token($token, $id)
   {
       return $this->db->table($this->users)
       ->where('user_id', $id)
       ->update($token);
   }

   //function get user
    public function get_logged_user()
    {
        if ($this->is_logged_in()) 
        {
            return $this->db->table($this->users)
            ->where('user_id', session()->get('user_id'))
            // ->select('user_code, user_name, user_mobile, user_email, user_role, user_photo, user_aff_link, user_id, user_date, user_status')
            ->get()
            ->getRow();
        }
    }

    //is logged in
    public function is_logged_in()
    {
        //check if user logged in
        if (session()->get('logged_in') == true &&
            !empty($this->get_user(session()->get('user_id')))) {
            return true;
        } else {
            return false;
        }
    }

    //is logged in
    public function check_session()
    {
        if(session()->get('user_id'))
        {
            $data = $this->get_user(session()->get('user_id'));
            if (session()->get('user_token') == $data->user_token){
                return true;
            } else {
                return false;
            }
        }else
        {
            return false;
        }
    }

    //get user by id
    public function get_user($id)
    {
         return $this->db->table($this->users)
        ->where('user_id', $id)
        ->get()
        ->getRow();
    }

     //get user by id
     public function get_user_by_id($id)
     {
         return $this->db->table($this->users)
             ->where('user_id', $id)
             ->get()
             ->getRow();
     }
     
    public function logout()
    {
        // session_start();

        // // Unset all session variables
        // $_SESSION = [];

        // Destroy the session
        session_destroy();
        return redirect()->to('login');
    }

}
