<?php

if (!function_exists('admin_url')) {
    function admin_url()
    {
        return base_url() . "admin/";
    }
}

if (!function_exists('admin_css')) {
    function admin_css()
    {
        return base_url() . "back/";
    }
}

if (!function_exists('front_css')) {
    function front_css()
    {
        return base_url() . "front/";
    }
}

//check session id
if (!function_exists('check_session')) {
    function check_session()
    {
        $auth = new \App\Models\AuthModel;
        $check = $auth->check_session();
        if (!$check) {
            if (session_status() === PHP_SESSION_ACTIVE)
                session_destroy();
            return redirect()->to('login');
        }
    }
}

// Check user Image Avaliable or Not
if (!function_exists('check_image')) {
    function check_image($url)
    {
        if ($url) {
            return base_url() . $url;
        } else {
            return base_url() . 'back/avatar.jpg';
        }
    }
}

// Check user Image Avaliable or Not
if (!function_exists('check_image_service')) {
    function check_image_service($url)
    {
        if ($url) {
            return base_url() . $url;
        } else {
            return base_url() . 'front/no_preview.png';
        }
    }
}

//get logged user Details
if (!function_exists('user')) {
    function user()
    {
        $auth = new \App\Models\AuthModel;
        $user = $auth->get_logged_user();
        if (empty($user)) {
            $auth->logout();
        } else {
            return $user;
        }
    }
}

/**
 * get logged user Details End
 */

/**
 * Get User Data Start
 */
if (!function_exists('get_user_by_id')) {
    function get_user_by_id($id)
    {
        $auth = new \App\Models\AuthModel;
        $user = $auth->get_user_by_id($id);
        if ($user) {
            return $user;
        } else {
            return false;
        }
    }
}

if (!function_exists('get_user_by_mobile')) {
    function get_user_by_mobile($mobile)
    {
        $auth = new \App\Models\AuthModel;
        $user = $auth->get_user_by_mobile($mobile);
        if ($user) {
            return $user;
        } else {
            return false;
        }
    }
}

if (!function_exists('get_user_by_email')) {
    function get_user_by_email($email)
    {
        $auth = new \App\Models\AuthModel;
        $user = $auth->get_user_by_email($email);
        if ($user) {
            return $user;
        } else {
            return false;
        }
    }
}

/**
 * Get User Data End
 */

if (!function_exists('slug')) {
    function slug($string, $separator = '-')
    {
        if (is_null($string)) {
            return "";
        }
        $string = trim($string);
        $string = preg_replace("/[\s-]+/", " ", $string);
        $string = preg_replace("/[\s_]/", $separator, $string);

        return $string;
    }
}

if (!function_exists('convertToICO')) {
    function convertToICO($inputImagePath, $outputIcoPath)
    {
        exec("convert $inputImagePath -define icon:auto-resize=256,128,96,64,48,32,24,16 $outputIcoPath");
    }
}

if (!function_exists('generateRandomString')) {
    function generateRandomString($length)
    {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[random_int(0, $charactersLength - 1)];
        }
        return $randomString;
    }
}

// Check User Permission Helper
if (!function_exists('check_admin_permission')) {
    function check_admin_permission()
    {
        if (user()->user_role == 'Member' || user()->user_role == 'User') {
            $permission = 0;
        } else {
            $permission = 1;
        }

        return $permission;
    }
}


// Function to convert seconds to a human-readable format
function secondsToHumanReadable($databaseDateTimeStr)
{

    $databaseTimestamp = strtotime($databaseDateTimeStr);
    $seconds = time() - $databaseTimestamp;

    $units = array(
        "year"   => 365 * 24 * 3600,
        "month"  => 30 * 24 * 3600,
        "week"   => 7 * 24 * 3600,
        "day"    => 24 * 3600,
        "hour"   => 3600,
        "minute" => 60,
        "second" => 1,
    );

    foreach ($units as $unit => $value) {
        if ($seconds >= $value) {
            $numberOfUnits = floor($seconds / $value);
            return "$numberOfUnits $unit" . ($numberOfUnits > 1 ? "s" : "") . " ago";
        }
    }

    return "Just now";
}

function send_whatsapp($to, $message)
{
    $curl = curl_init();

    curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://wp.bulaa.org/api/create-message',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => array(
            'appkey' => 'aebc2cbc-5efe-43eb-b685-33d3acd18a33',
            'authkey' => '4Cb11taFpqVAn5XkrjVvE0RWnHoLIjNre03flkuWtMAX73TCM5',
            'to' => '91'.$to,
            'message' => $message,
            'sandbox' => 'false'
        ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);
    return $response;
}
