<?php

namespace App\Controllers;

use App\Models\BlogModel;
use App\Models\FrontModel;
use App\Models\SettingModel;
use App\Models\TourModel;

class Home extends BaseController
{
    //Home
    public function index()
    {
        $setting    = new SettingModel();
        $front      = new FrontModel();
        $blog       = new BlogModel();
        $tour       = new TourModel();
        $data['app_setting']        = $setting->get_application_setting();
        $data['title']              = $data['app_setting']->app_meta_title;
        $data['description']        = $data['app_setting']->app_meta_description;
        $data['keyword']            = $data['app_setting']->app_keywords;
        $data['all_slider']         = $front->get_slider();
        $data['about']              = $front->get_about_us();
        $data['all_testimonials']   = $front->get_all_testimonials();
        $data['all_blog']           = $blog->get_top_6_blog();
        $data['all_category']       = $tour->get_all_destination();
        return  view('front/include/header', $data)
            . view('front/home')
            . view('front/include/footer');
    }

    // About Us
    function about_us()
    {
        $setting = new SettingModel();
        $front   = new FrontModel();
        $data['app_setting']        = $setting->get_application_setting();
        $data['title']              = 'About Us | ' . $data['app_setting']->app_meta_title;
        $data['description']        = $data['app_setting']->app_meta_description;
        $data['keyword']            = $data['app_setting']->app_keywords;
        $data['data']              = $front->get_about_us();
        return  view('front/include/header', $data)
            . view('front/about')
            . view('front/include/footer');
    }

    //contact
    function contact_us()
    {
        $setting = new SettingModel();
        $tour   = new TourModel();
        $data['app_setting']        = $setting->get_application_setting();
        $data['title']              = 'Contact Us | ' . $data['app_setting']->app_meta_title;
        $data['description']        = $data['app_setting']->app_meta_description;
        $data['keyword']            = $data['app_setting']->app_keywords;
        $data['all_category']        = $tour->get_all_package_for_home();
        return  view('front/include/header', $data)
            . view('front/contact_us')
            . view('front/include/footer');
    }

    /**
     * Errro 404 page start
     */
    function error404()
    {
        $setting = new SettingModel();
        $data['app_setting']            = $setting->get_application_setting();
        $data['title']                  = $data['app_setting']->app_meta_title;
        $data['description']            = $data['app_setting']->app_meta_description;
        $data['keyword']                = $data['app_setting']->app_keywords;
        echo view('front/include/header', $data);
        echo view('front/error_404');
        echo view('front/include/footer');
    }
    /**
     * Errro 404 page End
     */

    /**
     * Page Details
     */
    function page_details($pageData)
    {
        $setting    = new SettingModel();
        $data['app_setting']                = $setting->get_application_setting();
        $data['title']                      = $pageData->page_name . ' || ' . $data['app_setting']->app_name;
        $data['description']                = $pageData->page_meta_keywords;
        $data['keyword']                    = $pageData->page_meta_description;
        $data['data']                       = $pageData;
        echo view('front/include/header', $data);
        echo view('front/page_details');
        echo view('front/include/footer');
    }

    /**
     * Blog Section Start
     */

    function all_blog()
    {
        $setting    = new SettingModel();
        $blog       = new BlogModel();
        $data['app_setting']                = $setting->get_application_setting();
        $data['title']                      = 'Blog || ' . $data['app_setting']->app_name;
        $data['description']                = $data['app_setting']->app_meta_description;
        $data['keyword']                    = $data['app_setting']->app_keywords;
        $data['all_blog']                   = $blog->get_all_blog();
        echo view('front/include/header', $data);
        echo view('front/all_blog');
        echo view('front/include/footer');
    }

    function blog_details($dataMain)
    {
        $setting = new SettingModel();
        $data['app_setting']        = $setting->get_application_setting();
        $data['title']              = $dataMain->title . ' - ' . $data['app_setting']->app_name;
        $data['description']        = $data['app_setting']->app_meta_description;
        $data['keyword']            = $data['app_setting']->app_keywords;
        $data['data']               = $dataMain;
        echo view('front/include/header', $data);
        echo view('front/blog_details');
        echo view('front/include/footer');
    }
    /**
     * Blog Section End
     */

    /**
     * Gallery Section Start
     */
    function gallery($type) 
    {
        $title = ucfirst($type);
        $setting = new SettingModel();
        $front   = new FrontModel();
        $data['app_setting']        = $setting->get_application_setting();
        $data['title']              = $title.' - ' . $data['app_setting']->app_name;
        $data['description']        = $data['app_setting']->app_meta_description;
        $data['keyword']            = $data['app_setting']->app_keywords;
        $data['page_title']         = $title;
        $data['data']               = $front->get_gallery_data_by_type($type);
        echo view('front/include/header', $data);
        echo view('front/gallery');
        echo view('front/include/footer');

    }
    /**
     * Gallery Section End
     */

    /**
     * Tour Section Start 
     */
    function destination_details($dataMain)
    {
        $setting = new SettingModel();
        $tour = new TourModel();
        $data['app_setting']        = $setting->get_application_setting();
        $data['title']              = $dataMain->destination_name . ' - ' . $data['app_setting']->app_name;
        $data['description']        = $data['app_setting']->app_meta_description;
        $data['keyword']            = $data['app_setting']->app_keywords;
        $data['data']               = $dataMain;
        $data['all_package']        = $tour->get_all_package_by_destination($dataMain);
        echo view('front/include/header', $data);
        echo view('front/destination_details');
        echo view('front/include/footer');
    }

    function package_details($dataMain)
    {
        $setting = new SettingModel();
        $data['app_setting']        = $setting->get_application_setting();
        $data['title']              = $dataMain->package_title;
        $data['description']        = $dataMain->package_meta_desciption;
        $data['keyword']            = $dataMain->package_meta_keyword;
        $data['data']               = $dataMain;
        echo view('front/include/header', $data);
        echo view('front/package_details');
        echo view('front/include/footer');
    }
    /**
     * Tour Section End
     */

    /**
     * Submit Lead form Start
     */
    function submit_lead_form()
    {
        $setting = new SettingModel();
        $app_setting = $setting->get_application_setting();

        // $recaptchaResponse = $this->request->getVar('g-recaptcha-response');
        // $secretKey = $app_setting->app_google_captcha_secret_key; // Replace with your Google reCAPTCHA Secret Key

        // // Verify reCAPTCHA
        // $verifyResponse = file_get_contents("https://www.google.com/recaptcha/api/siteverify?secret={$secretKey}&response={$recaptchaResponse}");
        // $responseData = json_decode($verifyResponse);

        // if (!$responseData->success || $responseData->score < 0.5) {
        //     session()->set('error', "reCAPTCHA verification failed. Please try again.");
        //     return redirect()->to($this->request->getUserAgent()->getReferrer());
        // }

        $tour = new TourModel();

        $data['lead_name'] = $this->request->getVar('lead_name');
        $data['lead_mobile'] = $this->request->getVar('lead_mobile');
        $data['lead_email'] = $this->request->getVar('lead_email');
        $data['lead_source'] = $this->request->getVar('lead_source');
        $data['lead_package_id'] = $this->request->getVar('lead_package_id');
        $data['lead_address'] = $this->request->getVar('lead_address');
        $data['lead_date'] = date('Y-m-d');

        
        if($this->request->getVar('message') !== null)
        {
             $existingComment[] = [
                'comment'           => $this->request->getVar('message'),
                'date'              => date('Y-m-d'),
                'next_follow_date'  => '',
                'comment_mode'      => 'Client Question'
            ];

        // Encode the merged comments array into JSON
            $data['lead_comment_and_date'] = json_encode($existingComment);
        }

        if ($tour->submit_lead_form($data)) {
            session()->set('success', "Thank Your For Your Interest. We will contact Your Shortly");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        } else {
            session()->set('error', "Form Submit Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }
    /**
     * Submit Lead form end
     */

    /**
     * Dynamic URL by Slug Start
     */
    public function any($slug)
    {
        $slug = slug($slug);
        if (empty($slug)) {
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
        $front = new FrontModel();
        $page = $front->get_page_by_slug($slug);
        if ($page) {
            $this->page_details($page);
        } else {
            $blog = new BlogModel();
            $post = $blog->get_blog_by_slug($slug);
            if ($post) {
                $this->blog_details($post);
            } else {
                $tour = new TourModel();
                $destination = $tour->get_destination_by_slug($slug);
                if ($destination) {
                    $this->destination_details($destination);
                } else {
                    $package = $tour->get_package_by_slug($slug);
                    if ($package) {
                        $this->package_details($package);
                    } else {
                        $this->error404();
                    }
                }
            }
        }
    }
    /**
     * Dynamic URL by Slug End
     */
}
