<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\AuthModel;
use App\Models\SettingModel;

class Auth extends BaseController
{
    public function login()
    {
        $data['validation'] =  \Config\Services::validation();
        if ($this->request->getMethod() === 'POST') {
            $input = $this->validate([
                'user_mobile' => 'required|numeric|min_length[10]|max_length[10]',
                'user_password' => 'required'
            ]);
            if (!$input) {
                session()->set('error', "Fill All Filed");
                return redirect()->route('login');
            } else {
                $auth = new AuthModel();
                $uerData = $auth->get_user_by_mobile($this->request->getVar('user_mobile'));
                if (!$uerData) {
                    session()->set('error', "Invalid Mobile No.");
                    return redirect()->route('login');
                } elseif ($uerData->user_status == 0) {
                    session()->set('error', "Account Not Approve. Please Wait For Account Approval.");
                    return redirect()->route('login');
                } elseif ($uerData->user_status == 2) {
                    session()->set('error', "You Account is Ban. Please Contact Administrator");
                    return redirect()->route('login');
                } elseif ($uerData->user_status == 3) {
                    session()->set('error', "Your Account Rejected. Please Contact Administrator");
                    return redirect()->route('login');
                } else {
                    $userData = $auth->get_user_by_mobile_and_password($this->request->getVar('user_mobile'), hash("sha256", $this->request->getVar('user_password')));

                    if (!$userData) {
                        session()->set('error', "Password Not Match");
                        return redirect()->route('login');
                    } else {
                        $token['user_token'] = rand(100000000, 999999999999);
                        $auth->update_token($token, $userData->user_id);
                        $ses_data = [
                            'user_id'           => $userData->user_id,
                            'name'              => $userData->user_name,
                            'mobile'            => $userData->user_mobile,
                            'role'              => $userData->user_role,
                            'user_token'        => $token['user_token'],
                            'logged_in'         => TRUE
                        ];
                        session()->set($ses_data);
                        return redirect()->to('/admin/dashboard');
                    }
                }
            }
        } else {
            if (session()->get('logged_in') == TRUE) {
                return redirect()->to('/admin/dashboard');
            } else {
                $setting = new SettingModel();
                $data['app_setting'] = $setting->get_application_setting();
                $data['title'] = 'Login - ' . $data['app_setting']->app_name;
                $data['description'] = $data['app_setting']->app_meta_description;
                $data['keyword'] = $data['app_setting']->app_keywords;
                return  view('login', $data);
            }
        }
    }
}
