<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\SettingModel;
use App\Models\TourModel;
use WebPConvert\WebPConvert;


class Tour extends BaseController
{
    /**
     * Destination Section Start
     */
    public function all_destination()
    {
        $setting = new SettingModel();
        $tour = new TourModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['all_data'] = $tour->get_all_destination();
        echo view('admin/include/header', $data);
        echo view('admin/tour/all_destination');
        echo view('admin/include/footer');
    }

    function add_destination()
    {
        $tour = new TourModel();

        $data['destination_name'] = $this->request->getVar('destination_name');
        $data['destination_slug'] = slug($this->request->getVar('destination_name'));
        $data['destination_description'] = $this->request->getVar('destination_description');

        if ($this->request->getFile('destination_image')->isValid() && !$this->request->getFile('destination_image')->hasMoved()) {
            $image_1 = $this->request->getFile('destination_image');
            $newName_1 = $image_1->getRandomName();
            $image_1->move('uploads', $newName_1);
            $extension = $image_1->getClientExtension();
            if ($extension === 'png' || $extension === 'jpg' || $extension === 'jpeg') {
                $source_1 = 'uploads/' . $newName_1;
                $destination_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                WebPConvert::convert($source_1, $destination_1, [
                    'fail' => 'original',
                    'quality' => 50
                ]);
                $webpPath_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                $data['destination_image'] = $webpPath_1;
                unlink($source_1);
            }
        }
        if ($tour->add_destination($data)) {
            session()->set('success', "Destination Successfully Saved");
            return redirect()->route('admin/tour/destinations');
        } else {
            session()->set('error', "Destination Saved Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }


    public function edit_destination($id)
    {
        $tour = new TourModel();
        $setting = new SettingModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['data'] = $tour->get_destination_by_id($id);
        echo view('admin/include/header', $data);
        echo view('admin/tour/edit_destination');
        echo view('admin/include/footer');
    }

    function update_destination($id)
    {
        $tour = new TourModel();

        $data['destination_name'] = $this->request->getVar('destination_name');
        $data['destination_slug'] = slug($this->request->getVar('destination_name'));
        $data['destination_description'] = $this->request->getVar('destination_description');

        $des_img = $tour->get_destination_by_id($id);

        if ($this->request->getFile('destination_image')->isValid() && !$this->request->getFile('destination_image')->hasMoved()) {
            $image_1 = $this->request->getFile('destination_image');
            $newName_1 = $image_1->getRandomName();
            $image_1->move('uploads', $newName_1);
            $extension = $image_1->getClientExtension();
            if ($extension === 'png' || $extension === 'jpg' || $extension === 'jpeg') {
                $source_1 = 'uploads/' . $newName_1;
                $destination_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                WebPConvert::convert($source_1, $destination_1, [
                    'fail' => 'original',
                    'quality' => 50
                ]);
                $webpPath_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                $data['destination_image'] = $webpPath_1;
                unlink($source_1);
                if (file_exists($des_img->destination_image)) {
                    unlink($des_img->destination_image);
                }
            }
        }
        if ($tour->update_destination($data, $id)) {
            session()->set('success', "Destination Successfully Saved");
            return redirect()->route('admin/tour/destinations');
        } else {
            session()->set('error', "Destination Saved Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    function delete_destination($id)
    {
        $tour = new TourModel();

        $image = $tour->get_destination_by_id($id);
        if (file_exists($image->destination_image)) {
            unlink($image->destination_image);
        }
        if ($tour->delete_destination($id)) {
            session()->set('success', "Destination Successfully Deleted");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        } else {
            session()->set('error', "Destination Deleted Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    /**
     * Destination Section End
     */

    /**
     * Package Section Start
     */
    function all_package()
    {
        $setting = new SettingModel();
        $tour = new TourModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['all_data'] = $tour->get_all_package();
        echo view('admin/include/header', $data);
        echo view('admin/tour/all_package');
        echo view('admin/include/footer');
    }

    function add_package()
    {
        $setting = new SettingModel();
        $tour = new TourModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['all_destination'] = $tour->get_all_destination();
        echo view('admin/include/header', $data);
        echo view('admin/tour/add_package');
        echo view('admin/include/footer');
    }

    function add_new_package()
    {
        $tour = new TourModel();

        $data['package_title'] = $this->request->getVar('package_title');
        $data['package_slug'] = slug($this->request->getVar('package_slug'));
        $data['package_meta_title'] = $this->request->getVar('package_meta_title');
        $data['package_meta_keyword'] = $this->request->getVar('package_meta_keyword');
        $data['package_meta_desciption'] = $this->request->getVar('package_meta_desciption');
        $data['package_price'] = $this->request->getVar('package_price');
        $data['package_duration'] = $this->request->getVar('package_duration');
        $data['package_start_date'] = $this->request->getVar('package_start_date');
        $data['package_end_date'] = $this->request->getVar('package_end_date');
        $data['package_front_description'] = $this->request->getVar('package_front_description');
        $data['package_description'] = $this->request->getVar('package_description');
        $data['package_travel_details'] = $this->request->getVar('package_travel_details');
        $data['package_pricing_details'] = $this->request->getVar('package_pricing_details');
        $data['package_extra_details'] = $this->request->getVar('package_extra_details');
        $data['package_destination'] = $this->request->getVar('package_destination');
        
        if ($this->request->getFile('package_photo')->isValid() && !$this->request->getFile('package_photo')->hasMoved()) {
            $image_1 = $this->request->getFile('package_photo');
            $newName_1 = $image_1->getRandomName();
            $image_1->move('uploads', $newName_1);
            $extension = $image_1->getClientExtension();
            if ($extension === 'png' || $extension === 'jpg' || $extension === 'jpeg') {
                $source_1 = 'uploads/' . $newName_1;
                $destination_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                WebPConvert::convert($source_1, $destination_1, [
                    'fail' => 'original',
                    'quality' => 50
                ]);
                $webpPath_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                $data['package_photo'] = $webpPath_1;
                unlink($source_1);
            }
        }
        if ($tour->add_new_package($data)) {
            session()->set('success', "Package Successfully Saved");
            return redirect()->route('admin/tour/package');
        } else {
            session()->set('error', "Package Saved Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    function edit_package($id)
    {
        $setting = new SettingModel();
        $tour = new TourModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['all_destination'] = $tour->get_all_destination();
        $data['data'] = $tour->get_package_by_id($id);
        echo view('admin/include/header', $data);
        echo view('admin/tour/edit_package');
        echo view('admin/include/footer');
    }

    function update_package($id)
    {
        $tour = new TourModel();

        $data['package_title'] = $this->request->getVar('package_title');
        $data['package_slug'] = slug($this->request->getVar('package_slug'));
        $data['package_meta_title'] = $this->request->getVar('package_meta_title');
        $data['package_meta_keyword'] = $this->request->getVar('package_meta_keyword');
        $data['package_meta_desciption'] = $this->request->getVar('package_meta_desciption');
        $data['package_price'] = $this->request->getVar('package_price');
        $data['package_duration'] = $this->request->getVar('package_duration');
        $data['package_start_date'] = $this->request->getVar('package_start_date');
        $data['package_end_date'] = $this->request->getVar('package_end_date');
        $data['package_front_description'] = $this->request->getVar('package_front_description');
        $data['package_description'] = $this->request->getVar('package_description');
        $data['package_travel_details'] = $this->request->getVar('package_travel_details');
        $data['package_pricing_details'] = $this->request->getVar('package_pricing_details');
        $data['package_extra_details'] = $this->request->getVar('package_extra_details');
        $data['package_destination'] = $this->request->getVar('package_destination');
        
        if ($this->request->getFile('package_photo')->isValid() && !$this->request->getFile('package_photo')->hasMoved()) {
            $image_1 = $this->request->getFile('package_photo');
            $newName_1 = $image_1->getRandomName();
            $image_1->move('uploads', $newName_1);
            $extension = $image_1->getClientExtension();
            if ($extension === 'png' || $extension === 'jpg' || $extension === 'jpeg') {
                $source_1 = 'uploads/' . $newName_1;
                $destination_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                WebPConvert::convert($source_1, $destination_1, [
                    'fail' => 'original',
                    'quality' => 50
                ]);
                $webpPath_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                $data['package_photo'] = $webpPath_1;
                unlink($source_1);
                
                $pack_img = $tour->get_package_by_id($id);

                if (file_exists($pack_img->package_photo)) {
                    unlink($pack_img->package_photo);
                }
            }
        }
        if ($tour->update_package($data, $id)) {
            session()->set('success', "Package Successfully Saved");
            return redirect()->route('admin/tour/package');
        } else {
            session()->set('error', "Package Saved Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    function delete_package($id)
    {
        $tour = new TourModel();

        $image = $tour->get_package_by_id($id);
        if (file_exists($image->package_photo)) {
            unlink($image->package_photo);
        }
        if ($tour->delete_package($id)) {
            session()->set('success', "Package Successfully Deleted");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        } else {
            session()->set('error', "Package Deleted Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    /**
     * Package Section End
     */
}
