<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\SettingModel;
use App\Models\UserModel;
use WebPConvert\WebPConvert;

class Setting extends BaseController
{

    /**
     * Application Setting Section Start
     */
    public function app_setting()
    {
        $redirectUrl = check_admin_permission();
        if (!$redirectUrl) {
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
        $setting = new SettingModel();
        $data['app_setting'] = $setting->get_application_setting();
        return  view('admin/include/header', $data)
            . view('admin/setting/app_setting')
            . view('admin/include/footer');
    }

    function update_application_setting()
    {
        $redirectUrl = check_admin_permission();
        if (!$redirectUrl) {
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
        $setting = new SettingModel();

        $data['app_name'] = $this->request->getVar('app_name');
        $data['app_keywords'] = $this->request->getVar('app_keywords');
        $data['app_meta_title'] = $this->request->getVar('app_meta_title');
        $data['app_meta_description'] = $this->request->getVar('app_meta_description');
        $data['app_address'] = $this->request->getVar('app_address');
        $data['app_email'] = $this->request->getVar('app_email');
        $data['app_mobile'] = $this->request->getVar('app_mobile');
        $data['app_footer_about_us'] = $this->request->getVar('app_footer_about_us');
        $data['app_head_code'] = $this->request->getVar('app_head_code');
        $data['app_mail_host'] = $this->request->getVar('app_mail_host');
        $data['app_mail_port'] = $this->request->getVar('app_mail_port');
        $data['app_mail_username'] = $this->request->getVar('app_mail_username');
        $data['app_mail_password'] = $this->request->getVar('app_mail_password');
        $data['app_google_captcha_site_key'] = $this->request->getVar('app_google_captcha_site_key');
        $data['app_google_captcha_secret_key'] = $this->request->getVar('app_google_captcha_secret_key');
        $data['app_js'] = $this->request->getVar('app_js');
        $data['app_css'] = $this->request->getVar('app_css');
        $data['app_color_1'] = $this->request->getVar('app_color_1');
        $data['app_color_2'] = $this->request->getVar('app_color_2');
        $data['app_facebook'] = $this->request->getVar('app_facebook');
        $data['app_twitter'] = $this->request->getVar('app_twitter');
        $data['app_youtube'] = $this->request->getVar('app_youtube');
        $data['app_linkedin'] = $this->request->getVar('app_linkedin');
        $data['app_telegram'] = $this->request->getVar('app_telegram');
        $data['app_instagram'] = $this->request->getVar('app_instagram');

        if ($this->request->getFile('app_logo')->isValid() && !$this->request->getFile('app_logo')->hasMoved()) {
            $image_1 = $this->request->getFile('app_logo');
            // Generate unique filename
            $newName_1 = $image_1->getRandomName();

            // Move the image to the uploads directory
            $image_1->move('uploads', $newName_1);

            $extension = $image_1->getClientExtension();

            if ($extension === 'png' || $extension === 'jpg' || $extension === 'jpeg') {
                // Convert the image to WebP
                $source_1 = 'uploads/' . $newName_1;
                $destination_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                WebPConvert::convert($source_1, $destination_1, [
                    'fail' => 'original',
                    'quality' => 50
                ]);
                $webpPath_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';

                $data['app_logo'] = $webpPath_1;

                unlink($source_1);

                $header_logo = $setting->get_application_setting();
                if (file_exists($header_logo->app_logo)) {
                    unlink($header_logo->app_logo);
                }
            }
        }

        if ($this->request->getFile('app_footer_logo')->isValid() && !$this->request->getFile('app_footer_logo')->hasMoved()) {

            $image_2 = $this->request->getFile('app_footer_logo');
            // Generate unique filename
            $newName_2 = $image_2->getRandomName();

            // Move the image to the uploads directory
            $image_2->move('uploads', $newName_2);

            $extension = $image_2->getClientExtension();

            if ($extension === 'png' || $extension === 'jpg' || $extension === 'jpeg') {
                // Convert the image to WebP
                $source = 'uploads/' . $newName_2;
                $destination = 'uploads/' . pathinfo($newName_2, PATHINFO_FILENAME) . '.webp';
                WebPConvert::convert($source, $destination, [
                    'fail' => 'original',
                    'quality' => 50
                ]);
                $webpPath = 'uploads/' . pathinfo($newName_2, PATHINFO_FILENAME) . '.webp';

                $data['app_footer_logo'] = $webpPath;

                unlink($source);

                $footer_logo = $setting->get_application_setting();
                if (file_exists($footer_logo->app_footer_logo)) {
                    unlink($footer_logo->app_footer_logo);
                }
            }
        }

        if ($this->request->getFile('app_fevicon')->isValid() && !$this->request->getFile('app_fevicon')->hasMoved()) {
            $image_3 = $this->request->getFile('app_fevicon');
            $tempPath = $image_3->getTempName(); // Get temp path safely

            if (!file_exists($tempPath)) {
                return redirect()->back()->with('error', 'File not found. Please try again.');
            }

            $imageName_3 = $image_3->getRandomName();
            $destination = 'uploads/' . $imageName_3;

            // Resize & Compress Image
            $image = \Config\Services::image()
                ->withFile($tempPath)
                ->resize(64, 64, true, 'height')
                ->save($destination, 100); // Save with 80% quality

            $data['app_fevicon'] = $destination;

            $fevicon_logo = $setting->get_application_setting();
            if (file_exists($fevicon_logo->app_fevicon)) {
                unlink($fevicon_logo->app_fevicon);
            }
        }


        if ($setting->update_application_setting($data)) {
            session()->set('success', "App Setting Successfully Saved");
            return redirect()->route('admin/setting/app_setting');
        } else {
            session()->set('error', "App Setting Saved Failed");
            return redirect()->route('admin/setting/app_setting');
        }
    }

    /**
     * Application Setting Section End
     */


    /**
     * Application Visual Setting Start
     */
    function visual_setting()
    {
        $redirectUrl = check_admin_permission();
        if (!$redirectUrl) {
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
        $setting = new SettingModel();
        $data['app_setting'] = $setting->get_application_setting();
        return  view('admin/include/header', $data)
            . view('admin/setting/visual_setting')
            . view('admin/include/footer');
    }

    public function update_app_color()
    {
        $redirectUrl = check_admin_permission();
        if (!$redirectUrl) {
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
        $setting = new SettingModel();

        $appColor1 = $this->request->getVar('app_color_1');
        $appColor2 = $this->request->getVar('app_color_2');
        $appColor3 = $this->request->getVar('app_color_3');

        $appColor1 = $this->request->getVar('app_color_1');
        if (isset($appColor1)) {
            $data['app_color_1'] = $appColor1;
        }

        $appColor2 = $this->request->getVar('app_color_2');
        if (isset($appColor2)) {
            $data['app_color_2'] = $appColor2;
        }

        $appColor3 = $this->request->getVar('app_color_3');
        if (isset($appColor3)) {
            $data['app_color_3'] = $appColor3;
        }
        if ($setting->update_color($data)) {
            return $this->response->setJSON([
                'status' => true,
                'message' => 'Color Updated Successfully'
            ]);
        } else {
            return $this->response->setJSON([
                'status' => false,
                'message' => 'Color Updated Failed'
            ]);
        }
    }

    /**
     * Application Visual Setting End
     */

     /**
     * Role Permission
     */

    public function all_permission()
    {
        $setting = new SettingModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['all_permission'] = $setting->get_all_role_permission();

        return view('admin/include/header', $data)
            . view('admin/role/all_permission')
            . view('admin/include/footer');
    }

    public function add_new_permission()
    {
        $setting = new SettingModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['all_menu'] = $setting->get_all_menu_and_sub_menu();

        return view('admin/include/header', $data)
            . view('admin/role/add_permission')
            . view('admin/include/footer');
    }

    public function permission_add()
    {
        $setting = new SettingModel();
        $roleName = $this->request->getVar('role_name');

        // Check if role name already exists
        if ($setting->check_role_name_exists($roleName)) {
            session()->set('error', 'Role Name Already Exists');
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }

        // Add new permission
        if ($setting->permission_add($this->request->getVar('role_name'))) {
            session()->set('success', 'Permission Successfully Added');
            return redirect()->to(base_url('admin/role_permission/all_permission'));
        } else {
            session()->set('error', 'Permission Addition Failed');
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    public function edit_permission($id)
    {
        $setting = new SettingModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['all_menu'] = $setting->get_all_menu_and_sub_menu();
        $data['permission'] = $setting->get_permission_by_id($id);

        return view('admin/include/header', $data)
            . view('admin/role/edit_permission')
            . view('admin/include/footer');
    }

    public function update_permission($id)
    {
        $setting = new SettingModel();
        if ($setting->update_permission($id, $this->request->getPost())) {
            session()->set('success', 'Permission Successfully Updated');
            return redirect()->to(base_url('admin/role_permission/all_permission'));
        } else {
            session()->set('error', 'Permission Update Failed');
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    public function delete_permission($id)
    {
        $setting = new SettingModel();
        if ($setting->delete_permission($id)) {
            session()->set('success', 'Permission Successfully Deleted');
            return redirect()->to(base_url('admin/role_permission/all_permission'));
        } else {
            session()->set('error', 'Permission Deletion Failed');
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

}
