<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\SettingModel;
use App\Models\TourModel;
use App\Models\UserModel;

class Lead extends BaseController
{
    /**
     * Lead Section Start
     */

    public function latest_lead()
    {
        error_reporting(0);
        $setting = new SettingModel();
        $tour = new TourModel();
        $user  = new UserModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['all_data'] = $tour->get_all_latest_lead_lead();
        $data['all_service'] = $tour->get_all_package_for_home();
        $data['all_users'] = $user->getLeadAssignUsers();
        echo view('admin/include/header', $data);
        echo view('admin/lead/latest_lead');
        echo view('admin/include/footer');
    }

    public function assigned_leads()
    {
        error_reporting(0);
        $setting = new SettingModel();
        $tour = new TourModel();
        $user  = new UserModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['all_data'] = $tour->get_all_assigned_lead();
        $data['all_service'] = $tour->get_all_package_for_home();
        $data['all_users'] = $user->getLeadAssignUsers();
        echo view('admin/include/header', $data);
        echo view('admin/lead/assigned_leads');
        echo view('admin/include/footer');
    }

    public function all_lead()
    {
        error_reporting(0);
        $setting = new SettingModel();
        $tour = new TourModel();
        $user  = new UserModel();

        // Get filter inputs
        $start_date = $this->request->getGet('start_date');
        $end_date = $this->request->getGet('end_date');
        $service = $this->request->getGet('service');
        $status = $this->request->getGet('status');

        $filters = [
            'start_date' => $start_date,
            'end_date'   => $end_date,
            'service'    => $service,
            'status'     => $status,
        ];

        $data['app_setting'] = $setting->get_application_setting();
        $data['all_data'] = $tour->get_all_lead($filters);
        $data['all_service'] = $tour->get_all_package_for_home();
        $data['all_users'] = $user->getLeadAssignUsers();
        echo view('admin/include/header', $data);
        echo view('admin/lead/all_lead');
        echo view('admin/include/footer');
    }

    function add_lead()
    {
        $tour = new TourModel();

        $data['lead_name'] = $this->request->getVar('lead_name');
        $data['lead_mobile'] = $this->request->getVar('lead_mobile');
        $data['lead_email'] = $this->request->getVar('lead_email');
        $data['lead_source'] = 'Manual Added';
        $data['lead_package_id'] = $this->request->getVar('lead_package_id');
        $data['lead_date'] = date('Y-m-d');

        if ($tour->submit_lead_form($data)) {

            session()->set('success', "Lead Status Successfully Added");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        } else {
            session()->set('error', "Lead Added Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    function assign_user($id)
    {
        $tour = new TourModel();

        $data['lead_employee_id'] = $this->request->getVar('lead_employee_id');

        if ($tour->assign_user_lead($data, $id)) {

            session()->set('success', "Lead Successfully Assigned");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        } else {
            session()->set('error', "Lead Assigned Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    public function assign_agent()
    {
        $tour = new TourModel();

        // Get the agent ID
        $lead_employee_id = $this->request->getVar('lead_employee_id');

        // Get comma-separated lead IDs and convert to array
        $lead_ids = explode(',', $this->request->getVar('lead_id'));

        if (!empty($lead_employee_id) && !empty($lead_ids)) {
            foreach ($lead_ids as $id) {
                $data = [
                    'lead_employee_id' => $lead_employee_id,
                ];
                $tour->assign_user_lead($data, $id); // Assuming this function assigns one lead at a time
            }

            session()->set('success', "Lead(s) Successfully Assigned");
        } else {
            session()->set('error', "Assignment Failed. Missing data.");
        }

        return redirect()->to($this->request->getUserAgent()->getReferrer());
    }


    function change_lead_status()
    {
        $tour = new TourModel();
        $data['lead_status'] =  $this->request->getVar('lead_status');

        if ($tour->change_lead_status($data, $this->request->getVar('lead_id'))) {

            session()->set('success', "Booking Status Successfully Changed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        } else {
            session()->set('error', "Booking Status Changed Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    public function add_new_call_conversation()
    {
        $request = service('request');

        // Retrieve data from the request
        $newComment = $request->getPost('lead_comment_and_date');
        $leadId = $request->getPost('lead_id');

        // Load the database service
        $db = \Config\Database::connect();
        $builder = $db->table('lead');

        // Fetch existing conversation data from the database
        $existingCommentJson = $builder->select('lead_comment_and_date')
            ->where('lead_id', $leadId)
            ->get()
            ->getRow();

        // Decode existing conversation JSON data
        $existingComment = $existingCommentJson ? json_decode($existingCommentJson->lead_comment_and_date, true) : [];

        // Ensure it's an array
        if (!is_array($existingComment)) {
            $existingComment = [];
        }

        // Append new comment to the existing comments array
        $existingComment[] = [
            'comment'           => $newComment,
            'date'              => date('Y-m-d'),
            'next_follow_date'  => $request->getPost('lead_comment_and_date_and_time'),
            'comment_mode'      => $request->getPost('comment_mode')
        ];

        // Encode the merged comments array into JSON
        $jsonMergedComments = json_encode($existingComment);

        // Update the conversation data in the database
        $builder->where('lead_id', $leadId);
        $updateStatus = $builder->update(['lead_comment_and_date' => $jsonMergedComments]);

        if ($updateStatus) {
            session()->set('success', "Conversation Successfully Added");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        } else {
            session()->set('error', "Conversation Added Faild");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    function delete_lead($id)
    {
        $tour = new TourModel();
        if ($tour->delete_lead($id)) {
            session()->set('success', "Booking Successfully Deleted");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        } else {
            session()->set('error', "Booking Deleted Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    public function uploadCSV()
    {
        try {

            $startTime = microtime(true);

            $db = \Config\Database::connect();
            $tour = new TourModel();
            $file = $this->request->getFile('uploadFile');

            if (!$file || !$file->isValid()) {
                return $this->response->setStatusCode(400)->setJSON([
                    "message" => "No file uploaded or invalid file.",
                    "inserted" => 0,
                    "updated" => 0,
                    "failed" => 0,
                    "total_rows" => 0,
                    "column_mismatches" => 0,
                ]);
            }

            if ($file->getExtension() !== 'csv') {
                return $this->response->setStatusCode(400)->setJSON([
                    "message" => "Invalid file format! Please upload a CSV file.",
                    "inserted" => 0,
                    "updated" => 0,
                    "failed" => 0,
                    "total_rows" => 0,
                    "column_mismatches" => 0,
                ]);
            }

            $csvFile = new \SplFileObject($file->getTempName());
            $csvFile->setFlags(\SplFileObject::READ_CSV);
            $csvFile->setCsvControl(",");
            $csvFile->rewind();
            $csvData = $csvFile->current();

            $csvData = [];
            foreach ($csvFile as $row) {
                if (!empty(array_filter($row))) {
                    $csvData[] = $row;
                }
            }

            if (empty($csvData)) {
                return $this->response->setStatusCode(400)->setJSON([
                    "message" => "The uploaded CSV file is empty.",
                    "inserted" => 0,
                    "updated" => 0,
                    "failed" => 0,
                    "total_rows" => 0,
                    "column_mismatches" => 0,
                ]);
            }
            $tableName = 'lead';

            $dbColumns = $tour->getFieldNames($tableName);

            $header = array_map(function ($col) {
                $col = trim($col);
                $col = strtolower($col);
                $col = str_replace(' ', '_', $col);
                return $col;
            }, $csvData[0]);

            unset($csvData[0]);

            $expectedColumns = count($header);
            $inserted = $updated = $failed = $columnMismatches = $originalColumnCount = $removedColumnsCount = 0;
            $totalRows = count($csvData);

            $csvData = array_slice($csvData, 0); //row

            $batchSize = 1000;
            $batchData = [];
            $allFilteredEmpty = true;
            $array = [];

            $db->transStart();

            foreach ($csvData as $row) {
                if (count($row) !== $expectedColumns) {
                    $columnMismatches++;
                    continue;
                }

                $row = array_slice($row, 0); //coloum

                $data = array_combine(array_slice($header, 0), $row);

                $originalColumnCount = count($data);

                $filteredData = array_filter($data, function ($key) use ($dbColumns) {
                    return in_array($key, $dbColumns);
                }, ARRAY_FILTER_USE_KEY);

                if ($filteredData) {
                    $allFilteredEmpty = false;

                    $removedColumnsCount = $originalColumnCount - count($filteredData);

                    $existingRecord = $tour->findExistingRecord($tableName, $filteredData);

                    $array[] = $existingRecord;

                    if ($existingRecord) {
                        if ($tour->updateData($tableName, $existingRecord, $filteredData)) {
                            $updated++;
                        } else {
                            $failed++;
                        }
                    } else {
                        $batchData[] = $filteredData;
                        $inserted++;
                    }

                    if (count($batchData) >= $batchSize) {
                        $db->table($tableName)->insertBatch($batchData);
                        $batchData = [];
                    }
                }
            }

            if ($allFilteredEmpty) {
                return $this->response->setStatusCode(400)->setJSON([
                    "message" => "No valid data found in the uploaded CSV.",
                    "inserted" => 0,
                    "updated" => 0,
                    "failed" => 0,
                    "total_rows" => $totalRows,
                    "column_mismatches" => $columnMismatches,
                    "execution_time" => 0
                ]);
            }

            if (!empty($batchData)) {
                $db->table($tableName)->insertBatch($batchData);
            }
            // echo '<pre>';
            // print_r($array);

            $db->transComplete();

            $executionTime = microtime(true) - $startTime;

            return $this->response->setJSON([
                "message" => "Upload completed.",
                "inserted" => $inserted,
                "updated" => $updated,
                "failed" => $failed,
                "total_rows" => $totalRows,
                "column_mismatches" => $removedColumnsCount,
                "execution_time" => round($executionTime, 4) . " seconds"
            ]);
        } catch (\Exception $e) {

            return $this->response->setStatusCode(500)->setJSON([
                "message" => "An error occurred while processing the CSV file.",
                "error" => $e->getMessage(),
                "inserted" => 0,
                "updated" => 0,
                "failed" => 0,
                "total_rows" => 0,
                "column_mismatches" => 0,
                "execution_time" => 0
            ]);
        }
    }


    function send_whatsapp_message()
    {
        $request = service('request');

        $message = $request->getPost('message');
        $resp = json_decode(send_whatsapp($this->request->getVar('mobile_no'), $message));

        if ($resp && isset($resp->message_status) && $resp->message_status == 'Success') {

            $newComment = $request->getPost('message');
            $leadId = $request->getPost('lead_id');

            $db = \Config\Database::connect();
            $builder = $db->table('lead');

            // Fetch existing conversation data from the database
            $existingCommentJson = $builder->select('lead_wp_conv_and_date')
                ->where('lead_id', $leadId)
                ->get()
                ->getRow();

            $existingComment = $existingCommentJson ? json_decode($existingCommentJson->lead_wp_conv_and_date, true) : [];

            if (!is_array($existingComment)) {
                $existingComment = [];
            }

            $existingComment[] = [
                'comment'           => $newComment,
                'date'              => date('Y-m-d'),
            ];

            $jsonMergedComments = json_encode($existingComment);

            $builder->where('lead_id', $leadId);
            $updateStatus = $builder->update(['lead_wp_conv_and_date' => $jsonMergedComments]);

            if ($updateStatus) {
                session()->set('success', "Whatsapp Message Successfully Send");
                return redirect()->to($this->request->getUserAgent()->getReferrer());
            } else {
                session()->set('error', "Whatsapp Message Sending Faild");
                return redirect()->to($this->request->getUserAgent()->getReferrer());
            }
        } else {
            session()->set('error', "Whatsapp Message Sending Faild");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    /**
     * Lead Section End
     */
}
