<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\FrontModel;
use App\Models\SettingModel;
use WebPConvert\WebPConvert;

class Front extends BaseController
{
    // Slider Section Start

    public function all_slider()
    {
        $redirectUrl = check_admin_permission();
        if (!$redirectUrl) {
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
        $setting = new SettingModel();
        $front = new FrontModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['all_data'] = $front->get_slider();
        return  view('admin/include/header', $data)
            . view('admin/front/all_slider')
            . view('admin/include/footer');
    }

    function add_slider()
    {
        $redirectUrl = check_admin_permission();
        if (!$redirectUrl) {
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
        $front = new FrontModel();
        $data['slider_heading']  = $this->request->getVar('slider_heading');
        $data['slider_sub_heading']  = $this->request->getVar('slider_sub_heading');

        if ($this->request->getFile('slider_image')->isValid() && !$this->request->getFile('slider_image')->hasMoved()) {

            $image = $this->request->getFile('slider_image');
            $newName = $image->getRandomName();
            $image->move('uploads', $newName);
            $extension = $image->getClientExtension();
            if ($extension === 'png' || $extension === 'jpg' || $extension === 'jpeg') {
                $source = 'uploads/' . $newName;
                $destination = 'uploads/' . pathinfo($newName, PATHINFO_FILENAME) . '.webp';
                WebPConvert::convert($source, $destination, [
                    'fail' => 'original',
                    'quality' => 10
                ]);
                $webpPath = 'uploads/' . pathinfo($newName, PATHINFO_FILENAME) . '.webp';
                $data['slider_image'] = $webpPath;
                unlink($source);
            }
        }

        if ($front->add_slider($data)) {
            session()->set('success', "Data Successfully Added");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        } else {
            session()->set('error', "Data Added Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    public function edit_slider($id)
    {
        $redirectUrl = check_admin_permission();
        if (!$redirectUrl) {
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
        $setting = new SettingModel();
        $front = new FrontModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['data'] = $front->get_slider_by_id($id);
        return  view('admin/include/header', $data)
            . view('admin/front/edit_slider')
            . view('admin/include/footer');
    }

    function update_slider($id)
    {
        $redirectUrl = check_admin_permission();
        if (!$redirectUrl) {
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
        $front = new FrontModel();
        $data['slider_heading']  = $this->request->getVar('slider_heading');
        $data['slider_sub_heading']  = $this->request->getVar('slider_sub_heading');

        if ($this->request->getFile('slider_image')->isValid() && !$this->request->getFile('slider_image')->hasMoved()) {

            $image = $this->request->getFile('slider_image');
            $newName = $image->getRandomName();
            $image->move('uploads', $newName);
            $extension = $image->getClientExtension();
            if ($extension === 'png' || $extension === 'jpg' || $extension === 'jpeg') {
                $source = 'uploads/' . $newName;
                $destination = 'uploads/' . pathinfo($newName, PATHINFO_FILENAME) . '.webp';
                WebPConvert::convert($source, $destination, [
                    'fail' => 'original',
                    'quality' => 10
                ]);
                $webpPath = 'uploads/' . pathinfo($newName, PATHINFO_FILENAME) . '.webp';
                $old_image = $front->get_slider_by_id($id);
                if (file_exists($old_image->slider_image)) {
                    unlink($old_image->slider_image);
                }
                $data['slider_image'] = $webpPath;
                unlink($source);
            }
        }

        if ($front->update_slider($data, $id)) {
            session()->set('success', "Data Successfully Updated");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        } else {
            session()->set('error', "Data Updated Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    function delete_slider($id)
    {
        $redirectUrl = check_admin_permission();
        if (!$redirectUrl) {
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }

        $front = new FrontModel();
        $old_image = $front->get_slider_by_id($id);
        if (file_exists($old_image->slider_image)) {
            unlink($old_image->slider_image);
        }
        if ($front->delete_slider($id)) {
            session()->set('success', "Data Successfully Deleted");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        } else {
            session()->set('error', "Data Deleted Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    // Slider Section End

    // About Us Section Start

    public function about_us()
    {
        $redirectUrl = check_admin_permission();
        if (!$redirectUrl) {
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
        $setting = new SettingModel();
        $front = new FrontModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['data'] = $front->get_about_us();
        return  view('admin/include/header', $data)
            . view('admin/front/about_us')
            . view('admin/include/footer');
    }

    function update_about_us()
    {
        $redirectUrl = check_admin_permission();
        if (!$redirectUrl) {
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
        $front = new FrontModel();
        $data['about_title']  = $this->request->getVar('about_title');
        $data['about_content']  = $this->request->getVar('about_content');

        if ($this->request->getFile('about_image')->isValid() && !$this->request->getFile('about_image')->hasMoved()) {

            $image = $this->request->getFile('about_image');
            $newName = $image->getRandomName();
            $image->move('uploads', $newName);
            $extension = $image->getClientExtension();
            if ($extension === 'png' || $extension === 'jpg' || $extension === 'jpeg') {
                $source = 'uploads/' . $newName;
                $destination = 'uploads/' . pathinfo($newName, PATHINFO_FILENAME) . '.webp';
                WebPConvert::convert($source, $destination, [
                    'fail' => 'original',
                    'quality' => 60
                ]);
                $webpPath = 'uploads/' . pathinfo($newName, PATHINFO_FILENAME) . '.webp';
                $old_image = $front->get_about_us();
                if (file_exists($old_image->about_image)) {
                    unlink($old_image->about_image);
                }
                $data['about_image'] = $webpPath;
                unlink($source);
            }
        }

        if ($front->update_front_setting($data)) {
            session()->set('success', "Data Successfully Updated");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        } else {
            session()->set('error', "Data Updated Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    // About Us Section end

    //Testimonials Section Start
    public function all_testimonial()
    {
        $setting = new SettingModel();
        $front = new FrontModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['all_data'] = $front->get_all_testimonials();
        return  view('admin/include/header', $data)
            . view('admin/front/all_testimonial')
            . view('admin/include/footer');
    }

    function add_testimonial()
    {
        $front = new FrontModel();

        $data['test_name'] = $this->request->getVar('test_name');
        $data['test_description'] = $this->request->getVar('test_description');
        $data['test_address'] = $this->request->getVar('test_address');
        $data['test_rating'] = $this->request->getVar('test_rating');

        if ($this->request->getFile('test_image')->isValid() && !$this->request->getFile('test_image')->hasMoved()) {
            $image = $this->request->getFile('test_image');
            $newName = $image->getRandomName();
            $image->move('uploads', $newName);
            $extension = $image->getClientExtension();
            if ($extension === 'png' || $extension === 'jpg' || $extension === 'jpeg') {
                $source = 'uploads/' . $newName;
                $destination = 'uploads/' . pathinfo($newName, PATHINFO_FILENAME) . '.webp';
                WebPConvert::convert($source, $destination, [
                    'fail' => 'original',
                    'quality' => 10
                ]);
                $webpPath = 'uploads/' . pathinfo($newName, PATHINFO_FILENAME) . '.webp';
                $data['test_image'] = $webpPath;
                unlink($source);
            }
        }

        if ($front->add_new_testimonials($data)) {
            session()->set('success', "Testimonial Successfully Saved");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        } else {
            session()->set('error', "Testimonial Saved Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    function edit_testimonial($id)
    {
        $setting = new SettingModel();
        $front = new FrontModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['data'] = $front->get_testimonials_by_id($id);
        return  view('admin/include/header', $data)
            . view('admin/front/edit_testimonial')
            . view('admin/include/footer');
    }

    public function update_testimonial($id)
    {

        $front = new FrontModel();

        $data['test_name'] = $this->request->getVar('test_name');
        $data['test_description'] = $this->request->getVar('test_description');
        $data['test_address'] = $this->request->getVar('test_address');
        $data['test_rating'] = $this->request->getVar('test_rating');

        // Check if a file has been uploaded
        if ($this->request->getFile('test_image')->isValid() && !$this->request->getFile('test_image')->hasMoved()) {
            $image = $this->request->getFile('test_image');
            $newName = $image->getRandomName();
            $image->move('uploads', $newName);
            $extension = $image->getClientExtension();
            if ($extension === 'png' || $extension === 'jpg' || $extension === 'jpeg') {
                $source = 'uploads/' . $newName;
                $destination = 'uploads/' . pathinfo($newName, PATHINFO_FILENAME) . '.webp';
                WebPConvert::convert($source, $destination, [
                    'fail' => 'original',
                    'quality' => 10
                ]);
                $webpPath = 'uploads/' . pathinfo($newName, PATHINFO_FILENAME) . '.webp';
                $old_image = $user->get_testimonials_by_code($code);
                if (file_exists($old_image->test_image)) {
                    unlink($old_image->test_image);
                }
                $data['test_image'] = $webpPath;
                unlink($source);
            }
        }

        if ($front->update_testimonials($data, $id)) {
            session()->set('success', "Testimonials Successfully Saved");
            return redirect()->route('admin/front_setting/testimonial');
        } else {
            session()->set('error', "Testimonials Saved Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    function delete_testimonial($id)
    {
        $front = new FrontModel();

        $image = $front->get_testimonials_by_id($id);

        if (file_exists($image->test_image)) {
            unlink($image->test_image);
        }

        if ($front->delete_testimonials($id)) {
            session()->set('success', "Testimonials Successfully Deleted");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        } else {
            session()->set('error', "Testimonials Deleted Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }
    // Testimopnials Section End

    /**
     * Dynamic Page Start  
     */

    function all_pages()
    {
        $redirectUrl = check_admin_permission();
        if (!$redirectUrl) {
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
        $setting = new SettingModel();
        $front = new FrontModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['all_data'] = $front->get_all_page();
        return  view('admin/include/header', $data)
            . view('admin/front/all_page')
            . view('admin/include/footer');
    }

    function add_page()
    {
        $redirectUrl = check_admin_permission();
        if (!$redirectUrl) {
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
        $setting = new SettingModel();
        $data['app_setting'] = $setting->get_application_setting();
        return  view('admin/include/header', $data)
            . view('admin/front/add_page')
            . view('admin/include/footer');
    }

    function add_new_page()
    {
        $redirectUrl = check_admin_permission();
        if (!$redirectUrl) {
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }

        $front = new FrontModel();
        $data = [
            'page_name'                 => $this->request->getVar('page_name'),
            'page_slug'                 => slug($this->request->getVar('page_name')),
            'page_meta_title'           => $this->request->getVar('page_meta_title'),
            'page_meta_description'     => $this->request->getVar('page_meta_description'),
            'page_meta_keywords'        => $this->request->getVar('page_meta_keywords'),
            'page_description'          => $this->request->getVar('page_description'),
        ];
        if ($front->add_new_page($data)) {
            session()->set('success', "Page Successfully Added");
            return redirect()->to('admin/front_setting/all_pages');
        } else {
            session()->set('error', "Page Added Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    function edit_page($id)
    {
        $redirectUrl = check_admin_permission();
        if (!$redirectUrl) {
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
        $setting = new SettingModel();
        $front = new FrontModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['data'] = $front->get_page_by_id($id);
        return  view('admin/include/header', $data)
            . view('admin/front/edit_page')
            . view('admin/include/footer');
    }

    function update_page($id)
    {
        $redirectUrl = check_admin_permission();
        if (!$redirectUrl) {
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }

        $front = new FrontModel();
        $data = [
            'page_name'                 => $this->request->getVar('page_name'),
            'page_slug'                 => slug($this->request->getVar('page_name')),
            'page_meta_title'           => $this->request->getVar('page_meta_title'),
            'page_meta_description'     => $this->request->getVar('page_meta_description'),
            'page_meta_keywords'        => $this->request->getVar('page_meta_keywords'),
            'page_description'          => $this->request->getVar('page_description'),
        ];
        if ($front->update_page($data, $id)) {
            session()->set('success', "Page Successfully Updated");
            return redirect()->to('admin/front_setting/all_pages');
        } else {
            session()->set('error', "Page Updated Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    function delete_page($id)
    {
        $redirectUrl = check_admin_permission();
        if (!$redirectUrl) {
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
        $front = new FrontModel();
        if ($front->delete_page($id)) {
            session()->set('success', "Page Successfully Deleted");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        } else {
            session()->set('error', "Page Deleted Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    /**
     * Dynamic Page End
     */

    /**
     * Gallery Section Start
     */
    public function all_gallery()
    {
        $setting = new SettingModel();
        $front = new FrontModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['all_data'] = $front->get_all_gallery();
        return  view('admin/include/header', $data)
            . view('admin/front/all_gallery')
            . view('admin/include/footer');
    }

    function add_gallery()
    {
        $front = new FrontModel();

        $data['gallery_name'] = $this->request->getVar('gallery_name');
        $data['gallery_type'] = $this->request->getVar('gallery_type');

        if ($this->request->getVar('gallery_type') == 'photo') {
            if ($this->request->getFile('gallery_content')->isValid() && !$this->request->getFile('gallery_content')->hasMoved()) {
                $image = $this->request->getFile('gallery_content');
                $newName = $image->getRandomName();
                $image->move('uploads', $newName);
                $extension = $image->getClientExtension();
                if ($extension === 'png' || $extension === 'jpg' || $extension === 'jpeg') {
                    $source = 'uploads/' . $newName;
                    $destination = 'uploads/' . pathinfo($newName, PATHINFO_FILENAME) . '.webp';
                    WebPConvert::convert($source, $destination, [
                        'fail' => 'original',
                        'quality' => 10
                    ]);
                    $webpPath = 'uploads/' . pathinfo($newName, PATHINFO_FILENAME) . '.webp';
                    $data['gallery_content'] = $webpPath;
                    unlink($source);
                }
            }
        } else {
            $data['gallery_content'] = $this->request->getVar('gallery_content');
        }

        if ($front->add_gallery($data)) {
            session()->set('success', "Gallery Successfully Saved");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        } else {
            session()->set('error', "Gallery Saved Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    function edit_gallery($id)
    {
        $setting = new SettingModel();
        $front = new FrontModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['data'] = $front->get_gallery_by_id($id);
        return  view('admin/include/header', $data)
            . view('admin/front/edit_gallery')
            . view('admin/include/footer');
    }

    public function update_gallery($id)
    {

        $front = new FrontModel();

        $data['gallery_name'] = $this->request->getVar('gallery_name');
        $data['gallery_type'] = $this->request->getVar('gallery_type');

        if ($this->request->getVar('gallery_type') == 'photo') {
            // Check if a file has been uploaded
            if ($this->request->getFile('gallery_content')->isValid() && !$this->request->getFile('gallery_content')->hasMoved()) {
                $image = $this->request->getFile('gallery_content');
                $newName = $image->getRandomName();
                $image->move('uploads', $newName);
                $extension = $image->getClientExtension();
                if ($extension === 'png' || $extension === 'jpg' || $extension === 'jpeg') {
                    $source = 'uploads/' . $newName;
                    $destination = 'uploads/' . pathinfo($newName, PATHINFO_FILENAME) . '.webp';
                    WebPConvert::convert($source, $destination, [
                        'fail' => 'original',
                        'quality' => 10
                    ]);
                    $webpPath = 'uploads/' . pathinfo($newName, PATHINFO_FILENAME) . '.webp';
                    $old_image = $user->get_testimonials_by_code($code);
                    if (file_exists($old_image->gallery_content)) {
                        unlink($old_image->gallery_content);
                    }
                    $data['gallery_content'] = $webpPath;
                    unlink($source);
                }
            }
        } else {
            $data['gallery_content'] = $this->request->getVar('gallery_content');
        }

        if ($front->update_gallery($data, $id)) {
            session()->set('success', "Gallery Successfully Saved");
            return redirect()->route('admin/front_setting/testimonial');
        } else {
            session()->set('error', "Gallery Saved Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    function delete_gallery($id)
    {
        $front = new FrontModel();

        $image = $front->get_gallery_by_id($id);

        if (file_exists($image->gallery_content)) {
            unlink($image->gallery_content);
        }

        if ($front->delete_gallery($id)) {
            session()->set('success', "Gallery Successfully Deleted");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        } else {
            session()->set('error', "Gallery Deleted Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }
    /**
     * Gallery Section End
     */
}
