<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\SettingModel;
use App\Models\UserModel;

class Clinic extends BaseController
{
    function all_clinic()
    {
        $setting = new SettingModel();
        $user = new UserModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['all_clinic'] = $user->get_all_clinic();
        return  view('admin/include/header', $data)
            . view('admin/clinic/all_clinic')
            . view('admin/include/footer');
    }

    function add_clinic()
    {
        $user = new UserModel();
        $setting = new SettingModel();
        $data['user_name']          = $this->request->getVar('user_name');
        $data['user_email']         = $this->request->getVar('user_email');
        $data['user_mobile']        = $this->request->getVar('user_mobile');
        $data['user_role']          = 'Clinic';
        $data['user_address']       = $this->request->getVar('user_address');
        $data['user_status']        =  1;
        $data['user_date']          = date('Y-m-d');
        $data['user_password']      = hash("sha256", $this->request->getVar('user_mobile'));
        $data['user_is_clinic']   = 1;
        $data['user_added_by']      = user()->user_id;

        // if ($this->request->getVar('user_email')) {
        //     $subject = 'Welcome to ' . $app_setting->application_name;
        //     $email_id = $this->request->getVar('user_email');
        //     $email_data['app_name'] = $app_setting->application_name;
        //     $email_data['password'] = $this->request->getVar('user_mobile');
        //     $email_data['mobile'] = $this->request->getVar('user_mobile');
        //     $msg = view('email/NewRegistration', $email_data);
        //     $email->send_email($email_id, $subject, $msg, $mailType = 'html');
        // }
        if ($user->add_user($data)) {
            session()->set('success', "Clinic Successfully Saved");
            return redirect()->route('admin/clinic/all_clinic');
        } else {
            session()->set('error', "Clinic Saved Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    function edit_clinic($id)
    {
        $setting = new SettingModel();
        $user = new UserModel();
        $data['app_setting']    = $setting->get_application_setting();
        $data['employee']           = get_user_by_id($id);
        echo view('admin/include/header', $data);
        echo view('admin/clinic/edit_clinic');
        echo view('admin/include/footer');
    }

    function update_clinic($id)
    {
        $user = new UserModel();
        $data['user_name']          = $this->request->getVar('user_name');
        $data['user_email']         = $this->request->getVar('user_email');
        $data['user_mobile']        = $this->request->getVar('user_mobile');
        $data['user_address']          = $this->request->getVar('user_address');
        if ($user->update_user($data, $id)) {
            session()->set('success', "Clinic Successfully Saved");
            return redirect()->route('admin/clinic/all_clinic');
        } else {
            session()->set('error', "Clinic Saved Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    function delete_clinic($id)
    {
        $user = new UserModel();

        $user_img = get_user_by_id($id);
        if (file_exists($user_img->user_photo)) 
        {
            unlink($user_img->user_photo);
        }
        if ($user->delete_user($id)) {
            session()->set('success', "Employee Successfully Deleted");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        } else {
            session()->set('error', "Employee Deleted Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    function login_employee($id)
    {
        $user = new UserModel();
        $userData = get_user_by_id($id);
        if ($userData) {
            $ses_data = [
                'user_id'       => $userData->user_id,
                'name'          => $userData->user_name,
                'mobile'        => $userData->user_mobile,
                'role'          => $userData->user_role,
                'logged_in'     => TRUE
            ];
            session()->set($ses_data);
            if ($userData->user_role != 'User') {
                return redirect()->to('/admin/dashboard');
            } else {
                return redirect()->to('my-account');
            }
        } else {
            session()->set('error', "Failed To Login");
            return redirect()->route('admin/user/view_all_users');
        }
    }

    /**
     * Clinic Section End
     */
}
