<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\BlogModel;
use App\Models\SettingModel;
use WebPConvert\WebPConvert;


class Blog extends BaseController
{
    
    public function add_new_blog()
    {
        $setting = new SettingModel();
        $data['app_setting'] = $setting->get_application_setting();
        echo view('admin/include/header', $data);
        echo view('admin/blog/add_new_blog');
        echo view('admin/include/footer');
    }

    function new_blog_add()
    {
        $blog = new BlogModel();

        $data['title'] = $this->request->getVar('title');
        $data['title_slug'] = slug($this->request->getVar('title'));
        $data['short_description'] = $this->request->getVar('short_description');
        $data['keywords'] = $this->request->getVar('keywords');
        $data['content'] = $this->request->getVar('content');
        $data['date'] = date('Y-m-d h:i:s');
        
        if ($this->request->getFile('image')->isValid() && !$this->request->getFile('image')->hasMoved()) {
            $image_1 = $this->request->getFile('image');
            $newName_1 = $image_1->getRandomName();
            $image_1->move('uploads', $newName_1);
            $extension = $image_1->getClientExtension();
            if ($extension === 'png' || $extension === 'jpg' || $extension === 'jpeg') {
                $source_1 = 'uploads/' . $newName_1;
                $destination_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                WebPConvert::convert($source_1, $destination_1, [
                    'fail' => 'original',
                    'quality' => 50
                ]);
                $webpPath_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                $data['image'] = $webpPath_1;
                unlink($source_1);
            }
        }
        if($blog->add_new_blog($data))
        {
            session()->set('success', "Blog Successfully Saved");
            return redirect()->route('admin/blog/all_blog');
        }
        else
        {
            session()->set('error', "Blog Saved Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    public function view_all_blog()
    {
        $blog = new BlogModel();
        $setting = new SettingModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['all_blog'] = $blog->get_all_blog();
        echo view('admin/include/header', $data);
        echo view('admin/blog/view_all_blog');
        echo view('admin/include/footer');
    }

    public function update_blog($id)
    {
        $blog = new BlogModel();
        $setting = new SettingModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['blog'] = $blog->get_blog_by_id($id);
        echo view('admin/include/header', $data);
        echo view('admin/blog/update_blog');
        echo view('admin/include/footer');
    }

    function update_blog_new($id)
    {
        $blog = new BlogModel();

        $data['title'] = $this->request->getVar('title');
        $data['title_slug'] = slug($this->request->getVar('title'));
        $data['short_description'] = $this->request->getVar('short_description');
        $data['keywords'] = $this->request->getVar('keywords');
        $data['content'] = $this->request->getVar('content');

        $blog_image = $blog->get_blog_by_id($id);
      
        if ($this->request->getFile('image')->isValid() && !$this->request->getFile('image')->hasMoved()) {
            $image_1 = $this->request->getFile('image');
            $newName_1 = $image_1->getRandomName();
            $image_1->move('uploads', $newName_1);
            $extension = $image_1->getClientExtension();
            if ($extension === 'png' || $extension === 'jpg' || $extension === 'jpeg') {
                $source_1 = 'uploads/' . $newName_1;
                $destination_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                WebPConvert::convert($source_1, $destination_1, [
                    'fail' => 'original',
                    'quality' => 50
                ]);
                $webpPath_1 = 'uploads/' . pathinfo($newName_1, PATHINFO_FILENAME) . '.webp';
                $data['image'] = $webpPath_1;
                unlink($source_1);
                if (file_exists($blog_image->image)) {
                    unlink($blog_image->image);
                }
            }
        }
        if($blog->update_blog_details($data, $id))
        {
            session()->set('success', "Blog Successfully Saved");
            return redirect()->route('admin/blog/all_blog');
        }
        else
        {
            session()->set('error', "Blog Saved Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }

    function delete_blog($id)
    {
        $blog = new BlogModel();

        $blog_img = $blog->get_blog_by_id($id);
        if(file_exists($blog_img->image))
        {
            unlink($blog_img->image);
        }
        if($blog->delete_blog($id))
        {
            session()->set('success', "Blog Successfully Deleted");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
        else
        {
            session()->set('error', "Blog Deleted Failed");
            return redirect()->to($this->request->getUserAgent()->getReferrer());
        }
    }  
}

