<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\SettingModel;
use App\Models\UserModel;
use WebPConvert\WebPConvert;

class Admin extends BaseController
{
    public function index()
    {
        $setting = new SettingModel();

        $data['app_setting'] = $setting->get_application_setting();
        echo view('admin/include/header', $data);
        echo view('admin/dashboard');
        echo view('admin/include/footer');
    }

    /**
     * User Profile Section Start 
     */
    public function my_profile()
    {
        $setting = new SettingModel();
        $user = new UserModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['user'] = get_user_by_id(user()->user_id);
        return  view('admin/include/header', $data)
            . view('admin/profile/my_profile')
            . view('admin/include/footer');
    }

    function update_profile_details()
    {
        $user = new UserModel();
        if ($this->request->getFile('user_photo')->isValid() && !$this->request->getFile('user_photo')->hasMoved()) {

            $image = $this->request->getFile('user_photo');
            // Generate unique filename
            $newName = $image->getRandomName();

            // Move the image to the uploads directory
            $image->move('uploads', $newName);

            $extension = $image->getClientExtension();

            if ($extension === 'png' || $extension === 'jpg' || $extension === 'jpeg') {
                // Convert the image to WebP
                $source = 'uploads/' . $newName;
                $destination = 'uploads/' . pathinfo($newName, PATHINFO_FILENAME) . '.webp';
                WebPConvert::convert($source, $destination, [
                    'fail' => 'original',
                    'quality' => 50
                ]);
                $webpPath = 'uploads/' . pathinfo($newName, PATHINFO_FILENAME) . '.webp';

                $data['user_photo'] = $webpPath;

                unlink($source);

                $old_image = get_user_by_id(user()->user_id);;
                if (file_exists($old_image->user_photo)) {
                    unlink($old_image->user_photo);
                }
            }
        }

        $data['user_name']      = $this->request->getVar('user_name');
        $data['user_mobile']    = $this->request->getVar('user_mobile');
        $data['user_email']     = $this->request->getVar('user_email');


        if ($user->update_user_profile_details($data, user()->user_id)) {
            session()->set('success', "Profile Successfully Updated");
            return redirect()->route('admin/my_profile');
        } else {
            session()->set('error', "Profile Update Failed");
            return redirect()->route('admin/my_profile');
        }
    }

    public function check_current_password($password)
    {
        $setting = new SettingModel();
        echo $setting->check_current_password($password);
    }

    public function update_password()
    {
        $setting = new SettingModel();
        $data['app_setting'] = $setting->get_application_setting();
        $data['user'] = get_user_by_id(user()->user_id);
        return  view('admin/include/header', $data)
            . view('admin/profile/update_password')
            . view('admin/include/footer');
    }

    function update_profile_password()
    {
        $user = new UserModel();
        $data['user_password'] = hash("sha256", $this->request->getVar('user_password'));
        if ($user->update_user_profile_details($data, user()->user_id)) {
            session()->set('success', "Password Successfully Saved");
            return redirect()->route('admin/update_password');
        } else {
            session()->set('error', "Password Saved Failed");
            return redirect()->route('admin/update_password');
        }
    }
    /**
     * User Profile Section End 
     */

    /**
     * Session Log Out
     */
    public function logout()
    {
        session()->destroy();
        return redirect()->to('login');
    }
    /**
     * Session Log Out
     */

   
}
