<?php

use CodeIgniter\Router\RouteCollection;
use App\Models\SettingModel;

/**
 * @var RouteCollection $routes
 */
//Home
$routes->get('/', 'Home::index');
//gallery
$routes->get('gallery/(:any)', 'Home::gallery/$1');
//Login
$routes->get('login', 'Auth::login');
$routes->post('login', 'Auth::login');
// abour us
$routes->get('about_us', 'Home::about_us');
//Contact Us
$routes->get('contact_us', 'Home::contact_us');
//all blog
$routes->get('blogs', 'Home::all_blog');
// submit lead form
$routes->post('submit_lead_form', 'Home::submit_lead_form');

//admin route
$routes->group('admin', ['filter' => 'auth'], function ($routes) {
    $routes->get('dashboard', 'Admin\Admin::index');
    $routes->get('my_profile', 'Admin\Admin::my_profile');
    $routes->post('update_profile_details', 'Admin\Admin::update_profile_details');
    $routes->get('check_current_password/(:any)', 'Admin\Admin::check_current_password/$1');
    $routes->get('update_password', 'Admin\Admin::update_password');
    $routes->post('update_password', 'Admin\Admin::update_profile_password');
    $routes->get('logout', 'Admin\Admin::logout');
    $routes->get('404', 'Admin\Admin::invalid_page');

    /**
     * Tour
     */
    $routes->group('tour', function ($routes) {
        // destionation
        $routes->get('destinations', 'Admin\Tour::all_destination');
        $routes->post('add_destination', 'Admin\Tour::add_destination');
        $routes->get('edit_destination/(:num)', 'Admin\Tour::edit_destination/$1');
        $routes->post('update_destination/(:num)', 'Admin\Tour::update_destination/$1');
        $routes->get('delete_destination/(:num)', 'Admin\Tour::delete_destination/$1');
        //package
        $routes->get('package', 'Admin\Tour::all_package');
        $routes->get('add_package', 'Admin\Tour::add_package');
        $routes->post('add_new_package', 'Admin\Tour::add_new_package');
        $routes->get('edit_package/(:num)', 'Admin\Tour::edit_package/$1');
        $routes->post('update_package/(:num)', 'Admin\Tour::update_package/$1');
        $routes->get('delete_package/(:num)', 'Admin\Tour::delete_package/$1');
    });

    /**
     * Booking
     */
    $routes->group('lead', function ($routes) {
        $routes->get('latest_lead', 'Admin\Lead::latest_lead');
        $routes->get('assigned_leads', 'Admin\Lead::assigned_leads');
        $routes->get('all_lead', 'Admin\Lead::all_lead');
        $routes->post('add_lead', 'Admin\Lead::add_lead');
        $routes->post('assign_user/(:num)', 'Admin\Lead::assign_user/$1');
        $routes->post('assign_agent', 'Admin\Lead::assign_agent');
        $routes->get('delete_lead/(:num)', 'Admin\Lead::delete_lead/$1');
        $routes->post('change_lead_status', 'Admin\Lead::change_lead_status');
        $routes->post('add_new_call_conversation', 'Admin\Lead::add_new_call_conversation');
        $routes->post('add_lead_bulk', 'Admin\Lead::uploadCSV');
        $routes->post('send_whatsapp_message', 'Admin\Lead::send_whatsapp_message');
    });

    /**
     * Clinic 
     */
    $routes->group('clinic', function ($routes) {
        $routes->get('all_clinic', 'Admin\Clinic::all_clinic');
        $routes->post('add_clinic', 'Admin\Clinic::add_clinic');
        $routes->get('edit_clinic/(:num)', 'Admin\Clinic::edit_clinic/$1');
        $routes->post('update_clinic/(:num)', 'Admin\Clinic::update_clinic/$1');
        $routes->get('delete_clinic/(:num)', 'Admin\Clinic::delete_clinic/$1');
    });

    /**
     * Role Permission
     */
    $routes->group('role_permission', function ($routes) {
        $routes->get('all_permission', 'Admin\Setting::all_permission');
        $routes->get('add_new_permission', 'Admin\Setting::add_new_permission');
        $routes->get('edit_permission/(:num)', 'Admin\Setting::edit_permission/$1');
        $routes->post('permission_add', 'Admin\Setting::permission_add');
        $routes->post('update_permission/(:num)', 'Admin\Setting::update_permission/$1');
        $routes->get('delete_permission/(:num)', 'Admin\Setting::delete_permission/$1');
    });

    /**
     *  employee
     */
    $routes->group('employee', function ($routes) {
        $routes->get('all_employee', 'Admin\Employee::all_employees');
        $routes->post('add_employee', 'Admin\Employee::add_employee');
        $routes->get('edit_employee/(:num)', 'Admin\Employee::edit_employee/$1');
        $routes->post('update_employee/(:num)', 'Admin\Employee::update_employee/$1');
        $routes->get('delete_employee/(:num)', 'Admin\Employee::delete_employee/$1');
        $routes->get('login_employee/(:num)', 'Admin\Employee::login_employee/$1');
    });

    /**
     * Blog
     */
    $routes->group('blog', function ($routes) {
        $routes->get('all_blog', 'Admin\Blog::view_all_blog');
        $routes->get('add_new_blog', 'Admin\Blog::add_new_blog');
        $routes->post('new_blog_add', 'Admin\Blog::new_blog_add');
        $routes->get('update_blog/(:num)', 'Admin\Blog::update_blog/$1');
        $routes->add('update_blog_new/(:num)', 'Admin\Blog::update_blog_new/$1');
        $routes->get('delete_blog/(:num)', 'Admin\Blog::delete_blog/$1');
    });

    /**
     * Front Setting
     */
    $routes->group('front_setting', function ($routes) {
        // Slider
        $routes->get('slider', 'Admin\Front::all_slider');
        $routes->post('add_slider', 'Admin\Front::add_slider');
        $routes->get('edit_slider/(:num)', 'Admin\Front::edit_slider/$1');
        $routes->post('update_slider/(:num)', 'Admin\Front::update_slider/$1');
        $routes->get('delete_slider/(:num)', 'Admin\Front::delete_slider/$1');
        // About us
        $routes->get('about_us', 'Admin\Front::about_us');
        $routes->post('update_about', 'Admin\Front::update_about_us');
        //testimonials
        $routes->get('testimonial', 'Admin\Front::all_testimonial');
        $routes->post('add_testimonial', 'Admin\Front::add_testimonial');
        $routes->get('edit_testimonial/(:num)', 'Admin\Front::edit_testimonial/$1');
        $routes->post('update_testimonial/(:num)', 'Admin\Front::update_testimonial/$1');
        $routes->get('delete_testimonial/(:num)', 'Admin\Front::delete_testimonial/$1');
        //page
        $routes->get('all_pages', 'Admin\Front::all_pages');
        $routes->get('add_page', 'Admin\Front::add_page');
        $routes->post('add_new_page', 'Admin\Front::add_new_page');
        $routes->get('edit_page/(:any)', 'Admin\Front::edit_page/$1');
        $routes->post('update_page/(:any)', 'Admin\Front::update_page/$1');
        $routes->get('delete_page/(:any)', 'Admin\Front::delete_page/$1');
        //gallery
        $routes->get('gallery', 'Admin\Front::all_gallery');
        $routes->post('add_gallery', 'Admin\Front::add_gallery');
        $routes->get('edit_gallery/(:num)', 'Admin\Front::edit_gallery/$1');
        $routes->post('update_gallery/(:num)', 'Admin\Front::update_gallery/$1');
        $routes->get('delete_gallery/(:num)', 'Admin\Front::delete_gallery/$1');

        
    });

    /**
     * Setting
     */
    $routes->group('setting', function ($routes) {
        $routes->get('app_setting', 'Admin\Setting::app_setting');
        $routes->post('update_application_setting', 'Admin\Setting::update_application_setting');
    });
});

// Custom route for blog & blog category
$routes->get('(:any)', 'Home::any/$1');
